/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.crypto.core.impl;

import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.baseservice.co.COService;
import cn.com.westone.wcspsdk.baseservice.co.Decryptor;
import cn.com.westone.wcspsdk.baseservice.co.Encryptor;
import cn.com.westone.wcspsdk.baseservice.co.SecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMService;
import cn.com.westone.wcspsdk.baseservice.km.KeyNoUpdateStrategySpec;
import cn.com.westone.wcspsdk.baseservice.km.KeyUpdateStrategySpec;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.smarthse.crypto.config.WcspProperties;
import cn.smarthse.crypto.core.AbstractCryptoManager;
import cn.smarthse.crypto.core.ISm4CryptoManager;
import cn.smarthse.crypto.core.SM4Context;
import cn.smarthse.crypto.exception.CryptoException;
import cn.smarthse.crypto.exception.ErrorCode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"wcsp.enabled"}, havingValue="true")
public class Sm4CryptoManager
extends AbstractCryptoManager
implements ISm4CryptoManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Sm4CryptoManager.class);
    private final ThreadLocal<SM4Context> sm4ContextThreadLocal = new ThreadLocal();
    private static final String FIXED_ALIAS = "ZLWQ_SM4_FIXED_KEY";
    private volatile String fixedKeyId;
    private volatile boolean keyInitialized = Boolean.FALSE;

    public Sm4CryptoManager(WcspProperties wcspProperties) {
        super(wcspProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Lazy
    private void initializeFixedKey() {
        if (this.keyInitialized) {
            return;
        }
        Sm4CryptoManager sm4CryptoManager = this;
        synchronized (sm4CryptoManager) {
            if (this.keyInitialized) {
                return;
            }
            CryptoServicePlatform platform = null;
            KMSecretKey kmSecretKey = null;
            try {
                platform = this.createNewPlatform();
                KMService kmService = KMService.getInstance((CryptoServicePlatform)platform);
                kmService.init(new Object[0]);
                KMSecretKey[] existingKeys = kmService.getSecretKeyList(FIXED_ALIAS);
                if (existingKeys != null && existingKeys.length > 0) {
                    kmSecretKey = existingKeys[0];
                    this.fixedKeyId = kmSecretKey.keyId();
                    log.info("\u627e\u5230\u522b\u540d\u4e3a[{}]\u7684SM4\u5bc6\u94a5::\u5bc6\u94a5\u603b\u6570[{}]", (Object)FIXED_ALIAS, (Object)existingKeys.length);
                } else {
                    kmSecretKey = kmService.createSecretKey("SM4", "ENC", FIXED_ALIAS, "\u5b9a\u4e49SM4\u5bc6\u94a5\u522b\u540d\u4f9b\u6301\u4e45\u4f7f\u7528", (KeyUpdateStrategySpec)new KeyNoUpdateStrategySpec.Builder().build());
                    this.fixedKeyId = kmSecretKey.keyId();
                    log.info("\u521b\u5efa\u65b0\u7684\u522b\u540d\u4e3a[{}]\u7684SM4\u5bc6\u94a5", (Object)FIXED_ALIAS);
                }
                log.info("\u521d\u59cb\u5316SM4\u5bc6\u94a5\u6210\u529f::keyId[{}]", (Object)this.fixedKeyId);
                this.keyInitialized = Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316SM4\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
                this.keyInitialized = Boolean.FALSE;
                throw new CryptoException(ErrorCode.SDK_INIT_FAILED, (Throwable)e);
            }
            finally {
                if (kmSecretKey != null) {
                    kmSecretKey.close();
                }
                if (platform != null) {
                    this.cleanupPlatform(platform);
                }
            }
        }
    }

    @Override
    public String encrypt(String plaintext) throws Exception {
        if (!this.keyInitialized) {
            this.initializeFixedKey();
        }
        log.info("--------------------> SM4\u6570\u636e\u52a0\u5bc6 <--------------------");
        SM4Context context = null;
        try {
            byte[] ciphertextByte;
            context = this.getOrCreateSM4Context();
            if (!context.isValid()) {
                throw new CryptoException(ErrorCode.CONTEXT_INVALID);
            }
            byte[] iv = context.getCoService().generateRandom(16);
            byte[] plaintextByte = ConversionUtils.Data.fromUTF8String((String)plaintext);
            try (Encryptor encryptor = context.getCoService().getEncryptor((SecretKey)context.getKmSecretKey(), iv, "CBC", "PKCS7Padding");){
                ciphertextByte = encryptor.doFinal(plaintextByte);
                log.info("\u52a0\u5bc6\u6210\u529f");
            }
            byte[] ivCiphertextByte = new byte[iv.length + ciphertextByte.length];
            System.arraycopy(iv, 0, ivCiphertextByte, 0, iv.length);
            System.arraycopy(ciphertextByte, 0, ivCiphertextByte, iv.length, ciphertextByte.length);
            String ivCiphertext = ConversionUtils.Data.toBase64String((byte[])ivCiphertextByte);
            log.info("\u52a0\u5bc6\u5b8c\u6210\uff08\u5bc6\u6587\u5305\u542biv\u4fe1\u606f\uff09");
            String string = ivCiphertext;
            return string;
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            this.cleanupContext(context);
            throw new CryptoException(ErrorCode.ENCRYPTION_FAILED, (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                this.returnContext(context);
            }
        }
    }

    @Override
    public String decrypt(String ivCiphertext) throws Exception {
        if (!this.keyInitialized) {
            this.initializeFixedKey();
        }
        log.info("--------------------> SM4\u6570\u636e\u89e3\u5bc6 <--------------------");
        SM4Context context = null;
        try {
            byte[] plaintextByte;
            context = this.getOrCreateSM4Context();
            if (!context.isValid()) {
                throw new CryptoException(ErrorCode.CONTEXT_INVALID);
            }
            byte[] ivCiphertextByte = ConversionUtils.Data.fromBase64String((String)ivCiphertext);
            byte[] iv = new byte[16];
            byte[] ciphertextByte = new byte[ivCiphertextByte.length - iv.length];
            System.arraycopy(ivCiphertextByte, 0, iv, 0, iv.length);
            System.arraycopy(ivCiphertextByte, iv.length, ciphertextByte, 0, ciphertextByte.length);
            try (Decryptor decryptor = context.getCoService().getDecryptor((SecretKey)context.getKmSecretKey(), iv, "CBC", "PKCS7Padding");){
                plaintextByte = decryptor.doFinal(ciphertextByte);
                log.info("\u89e3\u5bc6\u6210\u529f");
            }
            String plaintext = ConversionUtils.Data.toUTF8String((byte[])plaintextByte);
            log.info("\u89e3\u5bc6\u5b8c\u6210::\u660e\u6587\u90e8\u5206\u6570\u636e\u5df2\u6210\u529f\u89e3\u5bc6");
            String string = plaintext;
            return string;
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            this.cleanupContext(context);
            throw new CryptoException(ErrorCode.DECRYPTION_FAILED, (Throwable)e);
        }
        finally {
            if (context != null && context.isValid()) {
                this.returnContext(context);
            }
        }
    }

    private SM4Context getOrCreateSM4Context() {
        SM4Context context = this.sm4ContextThreadLocal.get();
        if (context == null) {
            context = this.createNewSM4Context();
            this.sm4ContextThreadLocal.set(context);
        }
        return context;
    }

    private SM4Context createNewSM4Context() {
        CryptoServicePlatform platform = null;
        KMSecretKey kmSecretKey = null;
        try {
            platform = this.getPlatformFromPool();
            KMService kmService = KMService.getInstance((CryptoServicePlatform)platform);
            kmService.init(new Object[0]);
            kmSecretKey = kmService.getSecretKey(this.fixedKeyId);
            if (kmSecretKey == null) {
                throw new CryptoException(ErrorCode.KEY_NOT_FOUND);
            }
            COService coService = COService.getInstance((String)"CO-REMOTE", (CryptoServicePlatform)platform);
            coService.init(new Object[0]);
            SM4Context sM4Context = new SM4Context(platform, kmService, coService, kmSecretKey);
            return sM4Context;
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316SM4Context\u5931\u8d25", (Throwable)e);
            if (kmSecretKey != null) {
                kmSecretKey.close();
            }
            if (platform != null) {
                this.cleanupPlatform(platform);
            }
            throw new CryptoException(ErrorCode.SDK_INIT_FAILED, (Throwable)e);
        }
        finally {
            if (platform != null) {
                this.recyclePlatformToPool(platform);
            }
        }
    }

    private void returnContext(SM4Context context) {
        if (context != null && context.isValid()) {
            context.close();
            this.sm4ContextThreadLocal.remove();
            if (context.getPlatform() != null) {
                this.recyclePlatformToPool(context.getPlatform());
            }
        }
    }

    private void cleanupContext(SM4Context context) {
        if (context != null) {
            context.invalidate();
            context.close();
            this.sm4ContextThreadLocal.remove();
            if (context.getPlatform() != null) {
                this.cleanupPlatform(context.getPlatform());
            }
        }
    }
}

