/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.crypto.core.impl;

import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.typicalservice.LightDataService;
import cn.com.westone.wcspsdk.util.ConversionUtils;
import cn.smarthse.crypto.config.WcspProperties;
import cn.smarthse.crypto.core.AbstractCryptoManager;
import cn.smarthse.crypto.core.ILightCryptoManager;
import cn.smarthse.crypto.exception.CryptoException;
import cn.smarthse.crypto.exception.ErrorCode;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"wcsp.enabled"}, havingValue="true")
public class LightCryptoManager
extends AbstractCryptoManager
implements ILightCryptoManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LightCryptoManager.class);
    private final ThreadLocal<LightDataService> lightDataServiceThreadLocal = new ThreadLocal();

    public LightCryptoManager(WcspProperties wcspProperties) {
        super(wcspProperties);
    }

    @Override
    public String encrypt(String plaintext) throws Exception {
        LightDataService lightService = null;
        CryptoServicePlatform platform = null;
        try {
            lightService = this.getOrCreateLightDataService();
            platform = lightService.platform();
            byte[] plaintextByte = ConversionUtils.Data.fromUTF8String((String)plaintext);
            byte[] ciphertextByte = lightService.encrypt(plaintextByte);
            String ciphertext = ConversionUtils.Data.toBase64String((byte[])ciphertextByte);
            log.info("\u52a0\u5bc6\u6210\u529f");
            String string = ciphertext;
            return string;
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u5931\u8d25\uff0c\u5bf9\u8c61\u5df2\u6807\u8bb0\u4e3a\u4e0d\u53ef\u590d\u7528", (Throwable)e);
            if (lightService != null) {
                this.lightDataServiceThreadLocal.remove();
            }
            if (platform != null) {
                this.cleanupPlatform(platform);
            }
            throw new CryptoException(ErrorCode.ENCRYPTION_FAILED, (Throwable)e);
        }
        finally {
            if (lightService != null && this.lightDataServiceThreadLocal.get() != null) {
                this.lightDataServiceThreadLocal.remove();
            }
            if (platform != null) {
                this.recyclePlatformToPool(platform);
            }
        }
    }

    @Override
    public String decrypt(String ciphertext) throws Exception {
        LightDataService lightService = null;
        CryptoServicePlatform platform = null;
        try {
            lightService = this.getOrCreateLightDataService();
            platform = lightService.platform();
            byte[] ciphertextByte = ConversionUtils.Data.fromBase64String((String)ciphertext);
            byte[] plaintextByte = lightService.decrypt(ciphertextByte);
            String plaintext = ConversionUtils.Data.toUTF8String((byte[])plaintextByte);
            log.info("\u89e3\u5bc6\u6210\u529f");
            String string = plaintext;
            return string;
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u5931\u8d25\uff0c\u5bf9\u8c61\u5df2\u6807\u8bb0\u4e3a\u4e0d\u53ef\u590d\u7528", (Throwable)e);
            if (lightService != null) {
                this.lightDataServiceThreadLocal.remove();
            }
            if (platform != null) {
                this.cleanupPlatform(platform);
            }
            throw new CryptoException(ErrorCode.ENCRYPTION_FAILED, (Throwable)e);
        }
        finally {
            if (lightService != null && this.lightDataServiceThreadLocal.get() != null) {
                this.lightDataServiceThreadLocal.remove();
            }
            if (platform != null) {
                this.recyclePlatformToPool(platform);
            }
        }
    }

    private LightDataService getOrCreateLightDataService() {
        LightDataService lightService = this.lightDataServiceThreadLocal.get();
        if (lightService == null) {
            lightService = this.createNewLightDataService();
            this.lightDataServiceThreadLocal.set(lightService);
        }
        return lightService;
    }

    private LightDataService createNewLightDataService() {
        CryptoServicePlatform platform = this.getPlatformFromPool();
        try {
            LightDataService lightDataService = LightDataService.getInstance((CryptoServicePlatform)platform);
            lightDataService.init(new Object[0]);
            return lightDataService;
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u8f7b\u91cf\u7ea7\u670d\u52a1\u5931\u8d25", (Throwable)e);
            this.recyclePlatformToPool(platform);
            throw new CryptoException(ErrorCode.SDK_INIT_FAILED, (Throwable)e);
        }
    }

    private void cleanup() {
        LightDataService lightService = this.lightDataServiceThreadLocal.get();
        if (lightService != null) {
            try {
                CryptoServicePlatform platform = lightService.platform();
                this.cleanupPlatform(platform);
            }
            catch (Exception e) {
                log.error("\u6e05\u7406\u8f7b\u91cf\u7ea7\u670d\u52a1\u8d44\u6e90\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            finally {
                this.lightDataServiceThreadLocal.remove();
            }
        }
    }
}

