/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.crypto.core;

import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.baseservice.co.COService;
import cn.com.westone.wcspsdk.baseservice.km.KMSecretKey;
import cn.com.westone.wcspsdk.baseservice.km.KMService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4Context
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SM4Context.class);
    private final CryptoServicePlatform platform;
    private final KMService kmService;
    private final COService coService;
    private final KMSecretKey kmSecretKey;
    private boolean valid;

    public SM4Context(CryptoServicePlatform platform, KMService kmService, COService coService, KMSecretKey kmSecretKey) {
        this.platform = platform;
        this.kmService = kmService;
        this.coService = coService;
        this.kmSecretKey = kmSecretKey;
        this.valid = Boolean.TRUE;
    }

    public void invalidate() {
        this.valid = Boolean.FALSE;
    }

    @Override
    public void close() {
        try {
            if (this.kmSecretKey != null) {
                this.kmSecretKey.close();
            }
        }
        catch (Throwable t) {
            log.error("\u6e05\u7406SM4\u4e0a\u4e0b\u6587\u65f6\u53d1\u751f\u5f02\u5e38\uff01", t);
        }
        finally {
            this.valid = Boolean.FALSE;
        }
    }

    @Generated
    public CryptoServicePlatform getPlatform() {
        return this.platform;
    }

    @Generated
    public KMService getKmService() {
        return this.kmService;
    }

    @Generated
    public COService getCoService() {
        return this.coService;
    }

    @Generated
    public KMSecretKey getKmSecretKey() {
        return this.kmSecretKey;
    }

    @Generated
    public boolean isValid() {
        return this.valid;
    }

    @Generated
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SM4Context)) {
            return false;
        }
        SM4Context other = (SM4Context)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        CryptoServicePlatform this$platform = this.getPlatform();
        CryptoServicePlatform other$platform = other.getPlatform();
        if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
            return false;
        }
        KMService this$kmService = this.getKmService();
        KMService other$kmService = other.getKmService();
        if (this$kmService == null ? other$kmService != null : !this$kmService.equals(other$kmService)) {
            return false;
        }
        COService this$coService = this.getCoService();
        COService other$coService = other.getCoService();
        if (this$coService == null ? other$coService != null : !this$coService.equals(other$coService)) {
            return false;
        }
        KMSecretKey this$kmSecretKey = this.getKmSecretKey();
        KMSecretKey other$kmSecretKey = other.getKmSecretKey();
        return !(this$kmSecretKey == null ? other$kmSecretKey != null : !this$kmSecretKey.equals(other$kmSecretKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SM4Context;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        CryptoServicePlatform $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        KMService $kmService = this.getKmService();
        result = result * 59 + ($kmService == null ? 43 : $kmService.hashCode());
        COService $coService = this.getCoService();
        result = result * 59 + ($coService == null ? 43 : $coService.hashCode());
        KMSecretKey $kmSecretKey = this.getKmSecretKey();
        result = result * 59 + ($kmSecretKey == null ? 43 : $kmSecretKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SM4Context(platform=" + String.valueOf(this.getPlatform()) + ", kmService=" + String.valueOf(this.getKmService()) + ", coService=" + String.valueOf(this.getCoService()) + ", kmSecretKey=" + String.valueOf(this.getKmSecretKey()) + ", valid=" + this.isValid() + ")";
    }
}

