/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.crypto.core;

import cn.com.westone.wcspsdk.AuthParameterSpec;
import cn.com.westone.wcspsdk.AuthSecretParameterSpec;
import cn.com.westone.wcspsdk.CryptoServicePlatform;
import cn.com.westone.wcspsdk.InvalidParameterException;
import cn.com.westone.wcspsdk.WCSPException;
import cn.smarthse.crypto.config.WcspProperties;
import cn.smarthse.crypto.exception.CryptoException;
import cn.smarthse.crypto.exception.ErrorCode;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCryptoManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractCryptoManager.class);
    protected final WcspProperties wcspProperties;
    private static final int MAX_POOL_SIZE = 10;
    private final Semaphore platformSemaphore = new Semaphore(10, Boolean.TRUE);
    private final LinkedBlockingQueue<CryptoServicePlatform> platformPool = new LinkedBlockingQueue(10);

    protected CryptoServicePlatform getPlatformFromPool() {
        try {
            this.platformSemaphore.acquire();
            CryptoServicePlatform platform = this.platformPool.poll();
            if (platform == null) {
                platform = this.createNewPlatform();
                log.debug("\u521b\u5efa\u65b0\u7684\u5e73\u53f0\u5b9e\u4f8b");
            }
            return platform;
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5e73\u53f0\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
            Thread.currentThread().interrupt();
            throw new CryptoException(ErrorCode.PLATFORM_ACQUIRE_FAILED, (Throwable)e);
        }
    }

    protected CryptoServicePlatform createNewPlatform() throws WCSPException, InvalidParameterException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("url", this.wcspProperties.getUrl());
        params.put("workdir", this.wcspProperties.getWorkDir());
        CryptoServicePlatform platform = CryptoServicePlatform.getInstance();
        platform.init(this.wcspProperties.getTenantId(), this.wcspProperties.getAppId(), params);
        platform.authorize((AuthParameterSpec)new AuthSecretParameterSpec.Builder().setSecret(this.wcspProperties.getSecret()).build());
        return platform;
    }

    protected void recyclePlatformToPool(CryptoServicePlatform platform) {
        if (platform != null) {
            try {
                this.platformPool.offer(platform);
                this.platformSemaphore.release();
            }
            catch (Exception e) {
                log.error("\u5f52\u8fd8\u5e73\u53f0\u5b9e\u4f8b\u5230\u5bf9\u8c61\u6c60\u5931\u8d25", (Throwable)e);
                this.cleanupPlatform(platform);
            }
        }
    }

    protected void cleanupPlatform(CryptoServicePlatform platform) {
        if (platform != null) {
            try {
                log.debug("\u6e05\u7406\u5e73\u53f0\u5b9e\u4f8b");
                platform.finalize();
            }
            catch (Throwable t) {
                log.error("\u8c03\u7528\u5e73\u53f0\u5b9e\u4f8bfinalize\u65f6\u53d1\u751f\u5f02\u5e38", t);
            }
        }
    }

    @Generated
    public AbstractCryptoManager(WcspProperties wcspProperties) {
        this.wcspProperties = wcspProperties;
    }
}

