/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.crypto.config;

import cn.smarthse.crypto.config.WcspProperties;
import cn.smarthse.crypto.core.ICryptoManager;
import cn.smarthse.crypto.core.ILightCryptoManager;
import cn.smarthse.crypto.core.ISm4CryptoManager;
import cn.smarthse.crypto.core.impl.LightCryptoManager;
import cn.smarthse.crypto.core.impl.NoOpCryptoManager;
import cn.smarthse.crypto.core.impl.Sm4CryptoManager;
import jakarta.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@EnableConfigurationProperties(value={WcspProperties.class})
public class WcspAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WcspAutoConfiguration.class);
    private final WcspProperties wcspProperties;

    @PostConstruct
    public void init() {
        this.wcspProperties.validate();
    }

    @Bean
    @ConditionalOnProperty(value={"wcsp.enabled"}, havingValue="true")
    public ILightCryptoManager wcspLightEncryptor(WcspProperties wcspProperties) {
        log.info("\u521d\u59cb\u5316WCSP\uff08\u8f7b\u91cf\u7ea7\uff09\u52a0\u5bc6\u7ba1\u7406\u5668::URL[{}]::\u79df\u6237ID[{}]::\u5e94\u7528ID[{}]", new Object[]{wcspProperties.getUrl(), wcspProperties.getTenantId(), wcspProperties.getAppId()});
        return new LightCryptoManager(wcspProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"wcsp.enabled"}, havingValue="true")
    public ISm4CryptoManager wcspSm4Encryptor(WcspProperties wcspProperties) {
        log.info("\u521d\u59cb\u5316WCSP\uff08SM4\uff09\u52a0\u5bc6\u7ba1\u7406\u5668::URL[{}]::\u79df\u6237ID[{}]::\u5e94\u7528ID[{}]", new Object[]{wcspProperties.getUrl(), wcspProperties.getTenantId(), wcspProperties.getAppId()});
        return new Sm4CryptoManager(wcspProperties);
    }

    @Bean
    @ConditionalOnProperty(value={"wcsp.enabled"}, havingValue="false", matchIfMissing=true)
    public ICryptoManager noOpWcspEncryptor() {
        return new NoOpCryptoManager();
    }

    @Generated
    public WcspAutoConfiguration(WcspProperties wcspProperties) {
        this.wcspProperties = wcspProperties;
    }
}

