/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.xss;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.http.HtmlUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XssUtils {
    private static final Logger log = LoggerFactory.getLogger(XssUtils.class);

    public static String clean(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return HtmlUtil.cleanHtmlTag((String)value);
    }

    public static Object deepClean(Object obj) {
        return XssUtils.deepCleanInternal(obj, new IdentityHashMap<Object, Boolean>());
    }

    private static Object deepCleanInternal(Object obj, Map<Object, Boolean> visited) {
        if (obj == null) {
            return null;
        }
        if (visited.containsKey(obj)) {
            return obj;
        }
        visited.put(obj, Boolean.TRUE);
        if (ClassUtil.isJdkClass(obj.getClass())) {
            if (obj instanceof String) {
                return XssUtils.clean((String)obj);
            }
            return obj;
        }
        if (obj instanceof Collection) {
            return XssUtils.cleanCollection((Collection)obj, visited);
        }
        if (obj instanceof Map) {
            return XssUtils.cleanMap((Map)obj, visited);
        }
        if (obj.getClass().isArray()) {
            return XssUtils.cleanArray(obj, visited);
        }
        if (obj.getClass().isEnum()) {
            return obj;
        }
        if (XssUtils.isCompositeObject(obj)) {
            return XssUtils.cleanCompositeObject(obj, visited);
        }
        return obj;
    }

    private static boolean isCompositeObject(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        if (ClassUtil.isJdkClass(obj.getClass())) {
            return false;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isArray()) {
            return false;
        }
        if (clazz.isEnum()) {
            return false;
        }
        return XssUtils.hasProcessableFields(clazz);
    }

    private static boolean hasProcessableFields(Class<?> clazz) {
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            for (Field field : current.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                return true;
            }
        }
        return false;
    }

    private static Collection<?> cleanCollection(Collection<?> collection, Map<Object, Boolean> visited) {
        try {
            for (Object item : collection) {
                XssUtils.deepCleanInternal(item, visited);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u96c6\u5408\u4e2d\u7684\u5143\u7d20: ", (Throwable)e);
        }
        return collection;
    }

    private static Map<?, ?> cleanMap(Map<?, ?> map, Map<Object, Boolean> visited) {
        try {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object value = XssUtils.deepCleanInternal(entry.getValue(), visited);
                entry.setValue(value);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406Map \u4e2d\u7684\u5143\u7d20: ", (Throwable)e);
        }
        return map;
    }

    private static Object cleanArray(Object array, Map<Object, Boolean> visited) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            Array.set(array, i, XssUtils.deepCleanInternal(element, visited));
        }
        return array;
    }

    private static Object cleanCompositeObject(Object obj, Map<Object, Boolean> visited) {
        for (Class<?> clazz = obj.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers)) continue;
                try {
                    Object cleanedValue;
                    field.setAccessible(true);
                    Object value = field.get(obj);
                    if (value == null || value == (cleanedValue = XssUtils.deepCleanInternal(value, visited))) continue;
                    field.set(obj, cleanedValue);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
        return obj;
    }
}

