/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.xss;

import cn.smarthse.common.xss.XssUtils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class XssResponseInterceptor
implements HandlerInterceptor {
    @Value(value="${xss.response.enable:false}")
    private Boolean responseEnable;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        if (this.responseEnable != null && !this.responseEnable.booleanValue()) {
            return;
        }
        if (modelAndView == null) {
            return;
        }
        modelAndView.getModel().replaceAll((key, value) -> XssUtils.deepClean(value));
    }
}

