/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.word;

import cn.smarthse.common.util.word.CustomXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class OfficeUtil {
    public static CustomXWPFDocument generateWord(Map<String, Object> param, String template) {
        CustomXWPFDocument doc = null;
        try {
            OPCPackage pack = POIXMLDocument.openPackage((String)template);
            doc = new CustomXWPFDocument(pack);
            if (param != null && param.size() > 0) {
                List paragraphList = doc.getParagraphs();
                OfficeUtil.processParagraphs(paragraphList, param, doc);
                Iterator it = doc.getTablesIterator();
                while (it.hasNext()) {
                    XWPFTable table = (XWPFTable)it.next();
                    List rows = table.getRows();
                    for (XWPFTableRow row : rows) {
                        List cells = row.getTableCells();
                        for (XWPFTableCell cell : cells) {
                            List paragraphListTable = cell.getParagraphs();
                            OfficeUtil.processParagraphs(paragraphListTable, param, doc);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static void processParagraphs(List<XWPFParagraph> paragraphList, Map<String, Object> param, CustomXWPFDocument doc) {
        if (paragraphList != null && paragraphList.size() > 0) {
            for (XWPFParagraph paragraph : paragraphList) {
                if (paragraph.getSpacingBefore() >= 1000 || paragraph.getSpacingAfter() > 1000) {
                    paragraph.setSpacingBefore(0);
                    paragraph.setSpacingAfter(0);
                }
                paragraph.setIndentationLeft(0);
                paragraph.setIndentationRight(0);
                List runs = paragraph.getRuns();
                ArrayList allRuns = new ArrayList(runs);
                for (XWPFRun run : allRuns) {
                    String text = run.getText(0);
                    if (text == null) continue;
                    boolean isSetText = false;
                    for (Map.Entry<String, Object> entry : param.entrySet()) {
                        String key = entry.getKey();
                        if (text.indexOf(key) == -1) continue;
                        isSetText = true;
                        Object value = entry.getValue();
                        if (value instanceof String) {
                            text = text.replace(key, value.toString());
                            continue;
                        }
                        if (!(value instanceof Map)) continue;
                        text = text.replace(key, "");
                        Map pic = (Map)value;
                        int width = Integer.parseInt(pic.get("width").toString());
                        int height = Integer.parseInt(pic.get("height").toString());
                        int picType = OfficeUtil.getPictureType(pic.get("type").toString());
                        byte[] byteArray = (byte[])pic.get("content");
                        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(byteArray);
                        try {
                            String blipId = doc.addPictureData(byteInputStream, picType);
                            doc.createPicture(blipId, doc.getNextPicNameNumber(picType), width, height, paragraph);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!isSetText) continue;
                    run.setText(text, 0);
                }
            }
        }
    }

    private static int getPictureType(String picType) {
        int res = 4;
        if (picType != null) {
            if (picType.equalsIgnoreCase("png")) {
                res = 6;
            } else if (picType.equalsIgnoreCase("dib")) {
                res = 7;
            } else if (picType.equalsIgnoreCase("emf")) {
                res = 2;
            } else if (picType.equalsIgnoreCase("jpg") || picType.equalsIgnoreCase("jpeg")) {
                res = 5;
            } else if (picType.equalsIgnoreCase("wmf")) {
                res = 3;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStream2ByteArray(InputStream in, boolean isClose) {
        byte[] byteArray = null;
        try {
            int total = in.available();
            byteArray = new byte[total];
            in.read(byteArray);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (isClose) {
                try {
                    in.close();
                }
                catch (Exception e2) {
                    System.out.println("\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        return byteArray;
    }
}

