/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.validation;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.validation.DataValida;
import cn.smarthse.common.util.validation.RegexType;
import cn.smarthse.common.util.validation.RegexUtils;
import java.lang.reflect.Field;
import javax.cn.smarthse.modules.health.exception.ErrorEnum;
import javax.cn.smarthse.modules.health.exception.HealthException;

public class ValidateUtil {
    private static DataValida dv;

    public static void valid(Object object, String group) throws HealthException {
        Field[] fields;
        if (object == null) {
            throw new HealthException(ErrorEnum.PARAMETER_ERROR);
        }
        Class<?> clazz = object.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            if (ValidateUtil.isNeedValide(field, group)) {
                try {
                    ValidateUtil.validate(field, object);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            field.setAccessible(false);
        }
    }

    private static boolean isNeedValide(Field field, String group) {
        if (StringUtils.isEmpty((CharSequence)group) || "all".equals(group)) {
            return true;
        }
        dv = field.getAnnotation(DataValida.class);
        if (dv == null) {
            return false;
        }
        String[] groups = dv.group();
        if (groups == null || groups.length == 0) {
            return false;
        }
        for (String g : groups) {
            if (!g.equals(group)) continue;
            return true;
        }
        return false;
    }

    private static void validate(Field field, Object object) throws IllegalArgumentException, IllegalAccessException, HealthException {
        String name;
        dv = field.getAnnotation(DataValida.class);
        Object value = field.get(object);
        if (dv == null) {
            return;
        }
        String string = name = dv.name().equals("") ? field.getName() : dv.name();
        if (!dv.nullAble()) {
            if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
                throw new HealthException(name + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
            value = value.toString();
            for (String v : dv.nullStr()) {
                if (!value.equals(v)) continue;
                throw new HealthException(name + "\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (RegexUtils.isNumber(dv.maxLength())) {
            int maxLength = Integer.valueOf(dv.maxLength());
            if (value != null && value.toString().length() > maxLength) {
                throw new HealthException(name + "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7" + dv.maxLength());
            }
        }
        if (RegexUtils.isNumber(dv.minLength())) {
            int minLength = Integer.valueOf(dv.minLength());
            if (value == null || value.toString().length() < minLength) {
                throw new HealthException(name + "\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + dv.minLength());
            }
        }
        if (RegexUtils.isNumber(dv.max())) {
            if (!RegexUtils.isInteger(value.toString())) {
                throw new HealthException(name + "\u4e0d\u662f\u6574\u6570");
            }
            if (Long.valueOf(dv.max()) < Long.valueOf(value.toString())) {
                throw new HealthException(name + "\u4e0d\u80fd\u5927\u4e8e" + dv.max());
            }
        }
        if (RegexUtils.isNumber(dv.min())) {
            if (!RegexUtils.isInteger(value.toString())) {
                throw new HealthException(name + "\u4e0d\u662f\u6574\u6570");
            }
            if (Long.valueOf(dv.min()) > Long.valueOf(value.toString())) {
                throw new HealthException(name + "\u4e0d\u80fd\u5c0f\u4e8e" + dv.min());
            }
        }
        if (dv.regexType() != RegexType.NONE) {
            switch (dv.regexType()) {
                case NONE: {
                    break;
                }
                case SPECIALCHAR: {
                    if (!RegexUtils.hasSpecialChar(value.toString())) break;
                    throw new HealthException(name + "\u4e0d\u80fd\u542b\u6709\u7279\u6b8a\u5b57\u7b26");
                }
                case CHINESE: {
                    if (!RegexUtils.isChinese2(value.toString())) break;
                    throw new HealthException(name + "\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\u5b57\u7b26");
                }
                case EMAIL: {
                    if (RegexUtils.isEmail(value.toString())) break;
                    throw new HealthException(name + "\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                case IP: {
                    if (RegexUtils.isIp(value.toString())) break;
                    throw new HealthException(name + "\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                case NUMBER: {
                    if (RegexUtils.isNumber(value.toString())) break;
                    throw new HealthException(name + "\u4e0d\u662f\u6b63\u6574\u6570");
                }
                case INTEGER: {
                    if (!RegexUtils.isInteger(value + "")) {
                        throw new HealthException(name + "\u4e0d\u662f\u6574\u6570");
                    }
                }
                case PHONENUMBER: {
                    if (RegexUtils.isPhoneNumber(value.toString())) break;
                    throw new HealthException(name + "\u6709\u8bef");
                }
            }
        }
        if (!dv.regexExpression().equals("") && value.toString().matches(dv.regexExpression())) {
            throw new HealthException(name + "\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }
}

