/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.valid;

import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.valid.DataValida;
import cn.smarthse.common.util.valid.RegexType;
import cn.smarthse.common.util.valid.RegexUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateUtil {
    static Logger logger = LoggerFactory.getLogger(ValidateUtil.class);
    private static DataValida dv;

    public static Set<String> valid(Object object, String ... fieldsArr) {
        if (object == null) {
            return Collections.emptySet();
        }
        HashSet<String> validFieldSet = new HashSet<String>(Arrays.asList(fieldsArr));
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> tmpClass = object.getClass(); tmpClass != null && !tmpClass.getName().toLowerCase().equals("java.lang.object"); tmpClass = tmpClass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(tmpClass.getDeclaredFields()));
        }
        HashSet<String> validResult = new HashSet<String>();
        for (Field field : fieldList) {
            field.setAccessible(true);
            if (ValidateUtil.isNeedValide(field, validFieldSet)) {
                try {
                    String result = ValidateUtil.validate(field, object);
                    validResult.add(result);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error("\u6570\u636e\u9a8c\u8bc1\u51fa\u9519\uff1a" + e.getMessage());
                }
            }
            field.setAccessible(false);
        }
        return validResult;
    }

    private static boolean isNeedValide(Field field, HashSet<String> validFieldSet) {
        dv = field.getAnnotation(DataValida.class);
        if (dv == null) {
            return false;
        }
        if (CollectionUtils.isEmpty(validFieldSet)) {
            return true;
        }
        return validFieldSet.contains(field.getName());
    }

    private static String validate(Field field, Object object) throws IllegalAccessException {
        String name;
        dv = field.getAnnotation(DataValida.class);
        Object value = field.get(object);
        if (dv == null) {
            return "";
        }
        String string = name = dv.name().equals("") ? field.getName() : dv.name();
        if (!dv.nullAble()) {
            if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
                if (StringUtils.isNotBlank((CharSequence)dv.nullErrInfo())) {
                    return dv.nullErrInfo();
                }
                return name + "\u4e0d\u80fd\u4e3a\u7a7a";
            }
            value = value.toString();
            for (String v : dv.nullStr()) {
                if (!value.equals(v)) continue;
                return name + "\u4e0d\u80fd\u4e3a\u7a7a";
            }
        }
        if (RegexUtils.isNumber(dv.maxLength())) {
            int maxLength = Integer.valueOf(dv.maxLength());
            if (value != null && value.toString().length() > maxLength) {
                return name + "\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7" + dv.maxLength();
            }
        }
        if (RegexUtils.isNumber(dv.minLength())) {
            int minLength = Integer.valueOf(dv.minLength());
            if (value == null || value.toString().length() < minLength) {
                return name + "\u957f\u5ea6\u4e0d\u80fd\u5c0f\u4e8e" + dv.minLength();
            }
        }
        if (RegexUtils.isNumber(dv.max())) {
            if (!RegexUtils.isInteger(value.toString())) {
                return name + "\u4e0d\u662f\u6574\u6570";
            }
            if (Long.valueOf(dv.max()) < Long.valueOf(value.toString())) {
                return name + "\u4e0d\u80fd\u5927\u4e8e" + dv.max();
            }
        }
        if (RegexUtils.isNumber(dv.min())) {
            if (!RegexUtils.isInteger(value.toString())) {
                return name + "\u4e0d\u662f\u6574\u6570";
            }
            if (Long.valueOf(dv.min()) > Long.valueOf(value.toString())) {
                return name + "\u4e0d\u80fd\u5c0f\u4e8e" + dv.min();
            }
        }
        if (dv.regexType() != RegexType.NONE) {
            switch (dv.regexType()) {
                case NONE: {
                    break;
                }
                case SPECIALCHAR: {
                    if (!RegexUtils.hasSpecialChar(value.toString())) break;
                    return name + "\u4e0d\u80fd\u542b\u6709\u7279\u6b8a\u5b57\u7b26";
                }
                case CHINESE: {
                    if (!RegexUtils.isChinese2(value.toString())) break;
                    return name + "\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\u5b57\u7b26";
                }
                case EMAIL: {
                    if (RegexUtils.isEmail(value.toString())) break;
                    return name + "\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                case IP: {
                    if (RegexUtils.isIp(value.toString())) break;
                    return name + "\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                case NUMBER: {
                    if (RegexUtils.isNumber(value.toString())) break;
                    return name + "\u4e0d\u662f\u6b63\u6574\u6570";
                }
                case INTEGER: {
                    if (!RegexUtils.isInteger(value + "")) {
                        return name + "\u4e0d\u662f\u6574\u6570";
                    }
                }
                case PHONENUMBER: {
                    if (RegexUtils.isPhoneNumber(value.toString())) break;
                    return name + "\u6709\u8bef";
                }
            }
        }
        if (!dv.regexExpression().equals("") && value.toString().matches(dv.regexExpression())) {
            return name + "\u683c\u5f0f\u4e0d\u6b63\u786e";
        }
        return "";
    }
}

