/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.valid;

import cn.smarthse.common.util.StringUtils;
import java.util.Calendar;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtils {
    private static final Pattern MOBILE_RE = Pattern.compile("^1(3[0-9]|4[01456879]|5[0-35-9]|6[2567]|7[0-8]|8[0-9]|9[0-35-9])\\d{8}$");
    private static final Pattern PHONE_WITH_AREA_CODE_RE = Pattern.compile("^[0][1-9]{2,3}-[0-9]{5,10}$");
    private static final Pattern PHONE_WITHOUT_AREA_CODE_RE = Pattern.compile("^[1-9]{1}[0-9]{5,8}$");
    private static final Pattern EMAIL_RE = Pattern.compile("^\\w+@(\\w+\\.)+\\w+$");
    private static final Pattern ID_CARD_RE = Pattern.compile("^\\d{15}|\\d{17}[\\dxX]$");

    public static boolean isIp(String ip) {
        if (null == ip || "".equals(ip)) {
            return false;
        }
        String regex = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        return ip.matches(regex);
    }

    public static boolean isEmail(String email) {
        if (null == email || "".equals(email)) {
            return false;
        }
        String regex = "\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*";
        return email.matches(regex);
    }

    public static boolean isChinese(String text) {
        if (null == text || "".equals(text)) {
            return false;
        }
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(text);
        return m.find();
    }

    public static boolean isNumber(String number) {
        if (null == number || "".equals(number)) {
            return false;
        }
        String regex = "[0-9]*";
        return number.matches(regex);
    }

    public static boolean isInteger(String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        String regex = "^-?\\d+$";
        return number.matches(regex);
    }

    public static boolean isDecimal(String decimal, int count) {
        if (null == decimal || "".equals(decimal)) {
            return false;
        }
        String regex = "^(-)?(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){" + count + "})?$";
        return decimal.matches(regex);
    }

    public static boolean isPhoneNumber(String phoneNumber) {
        if (null == phoneNumber || "".equals(phoneNumber)) {
            return false;
        }
        String regex = "^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";
        return phoneNumber.matches(regex);
    }

    public static boolean hasSpecialChar(String text) {
        if (null == text || "".equals(text)) {
            return false;
        }
        return text.replaceAll("[a-z]*[A-Z]*\\d*-*_*\\s*", "").length() == 0;
    }

    public static boolean isChinese2(String strName) {
        char[] ch = strName.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            char c = ch[i];
            if (!RegexUtils.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    public static int getAreaLevel(Long areaId) {
        if (areaId == null) {
            return 0;
        }
        return areaId == areaId / 10000000000L * 10000000000L ? 1 : (areaId == areaId / 100000000L * 100000000L ? 2 : (areaId == areaId / 1000000L * 1000000L ? 3 : (areaId == areaId / 100L * 100L ? 4 : 5)));
    }

    public static int getAreaLevel(String areaIdStr) {
        Long areaId;
        try {
            areaId = Long.parseLong(areaIdStr);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return 0;
        }
        return RegexUtils.getAreaLevel(areaId);
    }

    public static void validatePhoneNumber(String number) {
        if (!RegexUtils.isPhone(number) && !RegexUtils.isMobile(number)) {
            throw new RuntimeException("\u53f7\u7801\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u5408\u6cd5\u683c\u5f0f\uff01");
        }
    }

    public static boolean isValidatePhoneNumber(String number) {
        return RegexUtils.isPhone(number) || RegexUtils.isMobile(number);
    }

    public static void validateEmail(String email) {
        if (!email.matches(EMAIL_RE.pattern())) {
            throw new RuntimeException("\u90ae\u7bb1\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u5408\u6cd5\u683c\u5f0f\uff01");
        }
    }

    public static void validateIdCard(String idCard) {
        if (!idCard.matches(ID_CARD_RE.pattern())) {
            throw new RuntimeException("\u8eab\u4efd\u8bc1\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u5408\u6cd5\u683c\u5f0f\uff01");
        }
    }

    public static void validatePersonalInfo(String idCard, Integer age, Integer gender) {
        RegexUtils.validateIdCard(idCard);
        if (age != null) {
            Calendar cal = Calendar.getInstance();
            int nowYear = cal.get(1);
            int nowMonth = cal.get(2) + 1;
            int nowDay = cal.get(5);
            int year = Integer.parseInt(idCard.substring(6, 10));
            int month = Integer.parseInt(idCard.substring(10, 12));
            int day = Integer.parseInt(idCard.substring(12, 14));
            boolean reach = month < nowMonth || month == nowMonth && day <= nowDay;
            int realAge = reach ? nowYear - year : nowYear - year - 1;
            if (!Objects.equals(age, realAge)) {
                throw new RuntimeException("\u5e74\u9f84\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
        if (gender != null) {
            boolean match;
            int flag = new Integer(idCard.substring(16, 17)) % 2;
            boolean bl = flag == 1 ? 1 == gender : (match = 2 == gender);
            if (!match) {
                throw new RuntimeException("\u6027\u522b\u4e0e\u8eab\u4efd\u8bc1\u4e0d\u7b26\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
        }
    }

    public static void validatePersonalInfo(String idCard, String age, String gender) {
        RegexUtils.validatePersonalInfo(idCard, Integer.parseInt(age), Integer.parseInt(gender));
    }

    private static boolean isMobile(String number) {
        Matcher matcher = MOBILE_RE.matcher(number);
        return matcher.matches();
    }

    private static boolean isPhone(String number) {
        Matcher matcher = number.length() > 9 ? PHONE_WITH_AREA_CODE_RE.matcher(number) : PHONE_WITHOUT_AREA_CODE_RE.matcher(number);
        return matcher.matches();
    }
}

