/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.thread;

import cn.smarthse.common.util.passwordLog.StringUtils;
import com.xxl.job.core.context.XxlJobHelper;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadUtil {
    private static final Logger log = LoggerFactory.getLogger(ThreadUtil.class);
    static Set<String> threadNameSet = new HashSet<String>();

    public static void printThreadInfo(ThreadPoolExecutor executor, String name) {
        if (!threadNameSet.contains(name)) {
            threadNameSet.add(name);
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
                if (executor.getActiveCount() > 0) {
                    log.info("\u7ebf\u7a0b\u6c60\uff1a{}, \u603b\u7ebf\u7a0b\u6c60\u6570\uff1a{}", (Object)name, (Object)executor.getPoolSize());
                    log.info("\u7ebf\u7a0b\u6c60\uff1a{}, \u6b63\u5728\u8fd0\u884c\u7ebf\u7a0b\u6570\uff1a{}", (Object)name, (Object)executor.getActiveCount());
                    log.info("\u7ebf\u7a0b\u6c60\uff1a{}, \u6267\u884c\u5b8c\u6210\u7ebf\u7a0b\u6570\uff1a{}", (Object)name, (Object)executor.getCompletedTaskCount());
                    log.info("\u7ebf\u7a0b\u6c60\uff1a{}, \u6700\u5927\u7ebf\u7a0b\u6570\uff1a{}", (Object)name, (Object)executor.getMaximumPoolSize());
                    log.info("\u7ebf\u7a0b\u6c60\uff1a{}, \u7b49\u5f85\u961f\u5217\u7ebf\u7a0b\u6570\uff1a{}", (Object)name, (Object)executor.getQueue().size());
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public static void printThreadInfo4XxlJob(ThreadPoolExecutor executor, String name) {
        if (!threadNameSet.contains(name)) {
            threadNameSet.add(name);
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
                if (executor.getActiveCount() > 0) {
                    StringBuffer sb = new StringBuffer("\n");
                    sb.append(StringUtils.format("\u7ebf\u7a0b\u6c60\uff1a{}, \u603b\u7ebf\u7a0b\u6c60\u6570\uff1a{}", name, executor.getPoolSize())).append("\n");
                    sb.append(StringUtils.format("\u7ebf\u7a0b\u6c60\uff1a{}, \u603b\u7ebf\u7a0b\u6c60\u6570\uff1a{}", name, executor.getPoolSize())).append("\n");
                    sb.append(StringUtils.format("\u7ebf\u7a0b\u6c60\uff1a{}, \u6b63\u5728\u8fd0\u884c\u7ebf\u7a0b\u6570\uff1a{}", name, executor.getActiveCount())).append("\n");
                    sb.append(StringUtils.format("\u7ebf\u7a0b\u6c60\uff1a{}, \u6267\u884c\u5b8c\u6210\u7ebf\u7a0b\u6570\uff1a{}", name, executor.getCompletedTaskCount())).append("\n");
                    sb.append(StringUtils.format("\u7ebf\u7a0b\u6c60\uff1a{}, \u6700\u5927\u7ebf\u7a0b\u6570\uff1a{}", name, executor.getMaximumPoolSize())).append("\n");
                    sb.append(StringUtils.format("\u7ebf\u7a0b\u6c60\uff1a{}, \u7b49\u5f85\u961f\u5217\u7ebf\u7a0b\u6570\uff1a{}", name, executor.getQueue().size())).append("\n");
                    XxlJobHelper.log((String)sb.toString(), (Object[])new Object[0]);
                }
            }, 0L, 5L, TimeUnit.SECONDS);
        }
    }
}

