/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.pdf;

import cn.hutool.core.io.FileUtil;
import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.pdf.ProcessInputSteramThread;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import net.coobird.thumbnailator.Thumbnails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WkHtmlUtil {
    private static final Logger log = LoggerFactory.getLogger(WkHtmlUtil.class);

    public static byte[] html2ImageBytes(String cmd, String sourceFilePath, String targetFilePath) {
        return WkHtmlUtil.baseTool("wkhtmltoimage", cmd, sourceFilePath, targetFilePath);
    }

    public static byte[] html2ImageBytesByCompress(String cmd, String sourceFilePath, String targetFilePath) {
        String filePath = WkHtmlUtil.baseToolForPath("wkhtmltoimage", cmd, sourceFilePath, targetFilePath);
        Thumbnails.of((String[])new String[]{filePath}).scale(1.0).toFile(targetFilePath);
        return FileUtil.readBytes((String)targetFilePath);
    }

    public static byte[] html2PdfBytes(String cmd, String sourceFilePath, String targetFilePath) {
        return WkHtmlUtil.baseTool("wkhtmltopdf", cmd, sourceFilePath, targetFilePath);
    }

    public static String html2PdfFilePath(String cmd, String sourceFilePath, String targetFilePath) throws InterruptedException, IOException {
        return WkHtmlUtil.baseToolForPath("wkhtmltopdf", cmd, sourceFilePath, targetFilePath);
    }

    private static byte[] baseTool(String tool, String cmd, String sourceFilePath, String targetFilePath) {
        String filePath = WkHtmlUtil.baseToolForPath(tool, cmd, sourceFilePath, targetFilePath);
        return FileUtil.readBytes((String)filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String baseToolForPath(String tool, String cmd, String sourceFilePath, String targetFilePath) throws InterruptedException, IOException {
        FileUtil.mkParentDirs((String)targetFilePath);
        String command = String.format("%s %s %s %s", WkHtmlUtil.getToolRootPath() + tool, cmd, sourceFilePath, targetFilePath);
        log.info("\u751f\u6210\u547d\u4ee4\uff1a{}", (Object)command);
        Process process = null;
        InputStream is = null;
        InputStream errIs = null;
        CountDownLatch latch = new CountDownLatch(2);
        try {
            process = Runtime.getRuntime().exec(command);
            is = process.getInputStream();
            errIs = process.getErrorStream();
            new Thread(new ProcessInputSteramThread(is, latch)).start();
            new Thread(new ProcessInputSteramThread(errIs, latch)).start();
            process.waitFor();
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fapdf \u5931\u8d25\uff1a", (Throwable)e);
        }
        finally {
            if (null != process) {
                latch.await();
                process.destroy();
            }
            if (is != null) {
                is.close();
            }
            if (errIs != null) {
                errIs.close();
            }
        }
        log.info("=============== FINISH: [{}] ===============", (Object)command);
        return targetFilePath;
    }

    private static String getToolRootPath() {
        String wkCommandPath = Global.getConfig("wkCommandPath");
        if (StringUtils.isNotBlank((CharSequence)wkCommandPath)) {
            return wkCommandPath;
        }
        return "";
    }
}

