/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.pdf;

import cn.smarthse.common.config.Global;
import cn.smarthse.common.util.CommonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToPdf {
    private static final Logger log = LoggerFactory.getLogger(HtmlToPdf.class);

    public static void html2Pdf(String htmlPath, String pdfOutPath) throws IOException, InterruptedException {
        HtmlToPdf.toPdf(htmlPath, pdfOutPath);
    }

    private static Process toPdf(String htmlPath, String pdfOutPath) throws IOException, InterruptedException {
        if (HtmlToPdf.validParam(htmlPath).booleanValue()) {
            return null;
        }
        if (HtmlToPdf.validParam(pdfOutPath).booleanValue()) {
            return null;
        }
        File file = CommonUtil.getFile(pdfOutPath);
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        String ml = "wkhtmltopdf";
        String cmd = ml + " -l -n --no-outline  -q -T 12.7mm -R 12.7mm -L 12.7mm -B 12.7mm  " + htmlPath + " " + pdfOutPath;
        log.info("\u751f\u6210pdf\u547d\u4ee4:{}", (Object)cmd);
        Process exec = Runtime.getRuntime().exec(cmd);
        exec.waitFor();
        return exec;
    }

    public static void html2PdfByParam(String htmlPath, String pdfOutPath, Map<String, String> params) throws IOException, InterruptedException {
        HtmlToPdf.toPdfByParam(htmlPath, pdfOutPath, params);
    }

    private static Process toPdfByParam(String htmlPath, String pdfOutPath, Map<String, String> params) throws IOException, InterruptedException {
        File file;
        File parentFile;
        if (HtmlToPdf.validParam(htmlPath).booleanValue()) {
            return null;
        }
        if (HtmlToPdf.validParam(pdfOutPath).booleanValue()) {
            return null;
        }
        Boolean haveFalse = false;
        if (params != null) {
            for (String param : params.values()) {
                if (!HtmlToPdf.validParam(param).booleanValue()) continue;
                return null;
            }
        }
        if (!(parentFile = (file = CommonUtil.getFile(pdfOutPath)).getParentFile()).exists()) {
            parentFile.mkdirs();
        }
        String paramStr = "";
        if (params != null) {
            for (String key : params.keySet()) {
                paramStr = paramStr + " " + key + " " + params.get(key) + " ";
            }
        }
        String ml = Global.getConfig("wkhtmltopdf.path");
        String cmd = ml + " -q " + paramStr + " " + htmlPath + " " + pdfOutPath;
        log.info("\u751f\u6210pdf\u547d\u4ee4:{}", (Object)cmd);
        Process exec = Runtime.getRuntime().exec(cmd);
        exec.waitFor();
        return exec;
    }

    public static Boolean validParam(String str) {
        if (str == null) {
            return true;
        }
        String inj_str = "#.&.;.,.|.*.?.~.<.>.^.(.).[.].{.}.$.`";
        String[] inj_stra = StringUtils.split((String)inj_str, (String)".");
        for (int i = 0; i < inj_stra.length; ++i) {
            if (str.indexOf(inj_stra[i]) < 0) continue;
            return true;
        }
        return false;
    }
}

