/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.passwordLog;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.passwordLog.HolidayTemplate;
import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ServiceException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolidayUtils {
    private static final Logger log = LoggerFactory.getLogger(HolidayUtils.class);
    public static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    public static final ConcurrentHashSet<LocalDate> holidayList = new ConcurrentHashSet();
    public static final ConcurrentHashSet<LocalDate> supplementaryShiftList = new ConcurrentHashSet();
    public static final ConcurrentHashMap<String, HolidayTemplate.content> allHolidayContentList = new ConcurrentHashMap();
    public static final Map<String, Boolean> holidayCalendar = new LinkedHashMap<String, Boolean>();
    public static final String url = "https://timor.tech/api/holiday/year/";
    public static final String customHoliday2023 = "{\"code\":0,\"holiday\":{\"01-01\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":3,\"date\":\"2023-01-01\"},\"01-02\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":2,\"date\":\"2023-01-02\"},\"01-21\":{\"holiday\":true,\"name\":\"\u9664\u5915\",\"wage\":3,\"date\":\"2023-01-21\"},\"01-22\":{\"holiday\":true,\"name\":\"\u521d\u4e00\",\"wage\":3,\"date\":\"2023-01-22\"},\"01-23\":{\"holiday\":true,\"name\":\"\u521d\u4e8c\",\"wage\":3,\"date\":\"2023-01-23\"},\"01-24\":{\"holiday\":true,\"name\":\"\u521d\u4e09\",\"wage\":3,\"date\":\"2023-01-24\"},\"01-25\":{\"holiday\":true,\"name\":\"\u521d\u56db\",\"wage\":2,\"date\":\"2023-01-25\"},\"01-26\":{\"holiday\":true,\"name\":\"\u521d\u4e94\",\"wage\":2,\"date\":\"2023-01-26\"},\"01-27\":{\"holiday\":true,\"name\":\"\u521d\u516d\",\"wage\":2,\"date\":\"2023-01-27\"},\"01-28\":{\"holiday\":false,\"name\":\"\u6625\u8282\u540e\u8865\u73ed\",\"wage\":1,\"after\":true,\"target\":\"\u6625\u8282\",\"date\":\"2023-01-28\"},\"01-29\":{\"holiday\":false,\"name\":\"\u6625\u8282\u540e\u8865\u73ed\",\"wage\":1,\"after\":true,\"target\":\"\u6625\u8282\",\"date\":\"2023-01-29\"},\"04-05\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":3,\"date\":\"2023-04-05\",\"rest\":4},\"04-23\":{\"holiday\":false,\"name\":\"\u52b3\u52a8\u8282\u524d\u8865\u73ed\",\"wage\":1,\"target\":\"\u52b3\u52a8\u8282\",\"after\":false,\"date\":\"2023-04-23\"},\"04-29\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":2,\"date\":\"2023-04-29\"},\"04-30\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":2,\"date\":\"2023-04-30\"},\"05-01\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2023-05-01\"},\"05-02\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2023-05-02\",\"rest\":1},\"05-03\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2023-05-03\"},\"05-06\":{\"holiday\":false,\"name\":\"\u52b3\u52a8\u8282\u540e\u8865\u73ed\",\"after\":true,\"wage\":1,\"target\":\"\u52b3\u52a8\u8282\",\"date\":\"2023-05-06\"},\"06-22\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":3,\"date\":\"2023-06-22\",\"rest\":21},\"06-23\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":3,\"date\":\"2023-06-23\"},\"06-24\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2023-06-24\"},\"06-25\":{\"holiday\":false,\"name\":\"\u7aef\u5348\u8282\u540e\u8865\u73ed\",\"wage\":1,\"target\":\"\u7aef\u5348\u8282\",\"after\":true,\"date\":\"2023-06-25\"},\"09-29\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":3,\"date\":\"2023-09-29\",\"rest\":90},\"09-30\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":3,\"date\":\"2023-09-30\"},\"10-01\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2023-10-01\"},\"10-02\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2023-10-02\",\"rest\":1},\"10-03\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2023-10-03\"},\"10-04\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2023-10-04\"},\"10-05\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2023-10-05\"},\"10-06\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2023-10-06\"},\"10-07\":{\"holiday\":false,\"after\":true,\"wage\":1,\"name\":\"\u56fd\u5e86\u8282\u540e\u8865\u73ed\",\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2023-10-07\"},\"10-08\":{\"holiday\":false,\"after\":true,\"wage\":1,\"name\":\"\u56fd\u5e86\u8282\u540e\u8865\u73ed\",\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2023-10-08\"},\"12-30\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":2,\"date\":\"2023-12-30\",\"rest\":59},\"12-31\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":2,\"date\":\"2023-12-31\"}}}";
    public static final String customHoliday2024 = "{\"code\":0,\"holiday\":{\"01-01\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":3,\"date\":\"2024-01-01\"},\"02-04\":{\"holiday\":false,\"name\":\"\u6625\u8282\u524d\u8865\u73ed\",\"wage\":1,\"after\":false,\"target\":\"\u6625\u8282\",\"date\":\"2024-02-04\",\"rest\":34},\"02-10\":{\"holiday\":true,\"name\":\"\u521d\u4e00\",\"wage\":3,\"date\":\"2024-02-10\",\"rest\":40},\"02-11\":{\"holiday\":true,\"name\":\"\u521d\u4e8c\",\"wage\":3,\"date\":\"2024-02-11\"},\"02-12\":{\"holiday\":true,\"name\":\"\u521d\u4e09\",\"wage\":3,\"date\":\"2024-02-12\"},\"02-13\":{\"holiday\":true,\"name\":\"\u521d\u56db\",\"wage\":2,\"date\":\"2024-02-13\"},\"02-14\":{\"holiday\":true,\"name\":\"\u521d\u4e94\",\"wage\":2,\"date\":\"2024-02-14\",\"rest\":1},\"02-15\":{\"holiday\":true,\"name\":\"\u521d\u516d\",\"wage\":2,\"date\":\"2024-02-15\"},\"02-16\":{\"holiday\":true,\"name\":\"\u521d\u4e03\",\"wage\":2,\"date\":\"2024-02-16\"},\"02-17\":{\"holiday\":true,\"name\":\"\u521d\u516b\",\"wage\":2,\"date\":\"2024-02-17\"},\"02-18\":{\"holiday\":false,\"name\":\"\u6625\u8282\u540e\u8865\u73ed\",\"wage\":1,\"after\":true,\"target\":\"\u6625\u8282\",\"date\":\"2024-02-18\"},\"04-04\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":3,\"date\":\"2024-04-04\",\"rest\":34},\"04-05\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":2,\"date\":\"2024-04-05\",\"rest\":1},\"04-06\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":2,\"date\":\"2024-04-06\"},\"04-07\":{\"holiday\":false,\"name\":\"\u6e05\u660e\u8282\u540e\u8865\u73ed\",\"wage\":1,\"target\":\"\u6e05\u660e\u8282\",\"after\":true,\"date\":\"2024-04-07\"},\"04-28\":{\"holiday\":false,\"name\":\"\u52b3\u52a8\u8282\u524d\u8865\u73ed\",\"wage\":1,\"target\":\"\u52b3\u52a8\u8282\",\"after\":false,\"date\":\"2024-04-28\",\"rest\":19},\"05-01\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2024-05-01\",\"rest\":22},\"05-02\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":2,\"date\":\"2024-05-02\",\"rest\":1},\"05-03\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2024-05-03\"},\"05-04\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2024-05-04\"},\"05-05\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2024-05-05\"},\"05-11\":{\"holiday\":false,\"name\":\"\u52b3\u52a8\u8282\u540e\u8865\u73ed\",\"after\":true,\"wage\":1,\"target\":\"\u52b3\u52a8\u8282\",\"date\":\"2024-05-11\"},\"06-08\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2024-06-08\",\"rest\":21},\"06-09\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2024-06-09\"},\"06-10\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":3,\"date\":\"2024-06-10\"},\"09-14\":{\"holiday\":false,\"name\":\"\u4e2d\u79cb\u8282\u524d\u8865\u73ed\",\"after\":false,\"wage\":1,\"target\":\"\u4e2d\u79cb\u8282\",\"date\":\"2024-09-14\",\"rest\":39},\"09-15\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":2,\"date\":\"2024-09-15\",\"rest\":40},\"09-16\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":2,\"date\":\"2024-09-16\",\"rest\":1},\"09-17\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":3,\"date\":\"2024-09-17\",\"rest\":1},\"09-29\":{\"holiday\":false,\"name\":\"\u56fd\u5e86\u8282\u524d\u8865\u73ed\",\"after\":false,\"wage\":1,\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2024-09-29\",\"rest\":9},\"10-01\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2024-10-01\",\"rest\":11},\"10-02\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2024-10-02\",\"rest\":1},\"10-03\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2024-10-03\"},\"10-04\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2024-10-04\"},\"10-05\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2024-10-05\"},\"10-06\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2024-10-06\",\"rest\":1},\"10-07\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2024-10-07\",\"rest\":1},\"10-12\":{\"holiday\":false,\"after\":true,\"wage\":1,\"name\":\"\u56fd\u5e86\u8282\u540e\u8865\u73ed\",\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2024-10-12\",\"rest\":4}}}";
    public static final String customHoliday2025 = "{\"code\":0,\"holiday\":{\"01-01\":{\"holiday\":true,\"name\":\"\u5143\u65e6\",\"wage\":3,\"date\":\"2025-01-01\",\"rest\":14},\"01-26\":{\"holiday\":false,\"name\":\"\u6625\u8282\u524d\u8865\u73ed\",\"wage\":1,\"after\":false,\"target\":\"\u6625\u8282\",\"date\":\"2025-01-26\",\"rest\":20},\"01-28\":{\"holiday\":true,\"name\":\"\u9664\u5915\",\"wage\":2,\"date\":\"2025-01-28\",\"rest\":22},\"01-29\":{\"holiday\":true,\"name\":\"\u521d\u4e00\",\"wage\":3,\"date\":\"2025-01-29\",\"rest\":1},\"01-30\":{\"holiday\":true,\"name\":\"\u521d\u4e8c\",\"wage\":3,\"date\":\"2025-01-30\",\"rest\":1},\"01-31\":{\"holiday\":true,\"name\":\"\u521d\u4e09\",\"wage\":3,\"date\":\"2025-01-31\",\"rest\":1},\"02-01\":{\"holiday\":true,\"name\":\"\u521d\u56db\",\"wage\":2,\"date\":\"2025-02-01\",\"rest\":1},\"02-02\":{\"holiday\":true,\"name\":\"\u521d\u4e94\",\"wage\":2,\"date\":\"2025-02-02\",\"rest\":1},\"02-03\":{\"holiday\":true,\"name\":\"\u521d\u516d\",\"wage\":2,\"date\":\"2025-02-03\",\"rest\":1},\"02-04\":{\"holiday\":true,\"name\":\"\u521d\u4e03\",\"wage\":2,\"date\":\"2025-02-04\",\"rest\":1},\"02-08\":{\"holiday\":false,\"name\":\"\u6625\u8282\u540e\u8865\u73ed\",\"wage\":1,\"target\":\"\u6625\u8282\",\"after\":true,\"date\":\"2025-02-08\",\"rest\":4},\"04-04\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":3,\"date\":\"2025-04-04\",\"rest\":16},\"04-05\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":2,\"date\":\"2025-04-05\",\"rest\":1},\"04-06\":{\"holiday\":true,\"name\":\"\u6e05\u660e\u8282\",\"wage\":2,\"date\":\"2025-04-06\",\"rest\":1},\"04-27\":{\"holiday\":false,\"name\":\"\u52b3\u52a8\u8282\u524d\u8865\u73ed\",\"wage\":1,\"target\":\"\u52b3\u52a8\u8282\",\"after\":false,\"date\":\"2025-04-27\",\"rest\":21},\"05-01\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-01\",\"rest\":25},\"05-02\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":2,\"date\":\"2025-05-02\",\"rest\":1},\"05-03\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-03\",\"rest\":1},\"05-04\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-04\"},\"05-05\":{\"holiday\":true,\"name\":\"\u52b3\u52a8\u8282\",\"wage\":3,\"date\":\"2025-05-05\"},\"05-31\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":3,\"date\":\"2025-05-31\"},\"06-01\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2025-06-01\"},\"06-02\":{\"holiday\":true,\"name\":\"\u7aef\u5348\u8282\",\"wage\":2,\"date\":\"2025-06-02\"},\"09-28\":{\"holiday\":false,\"name\":\"\u56fd\u5e86\u8282\u524d\u8865\u73ed\",\"after\":false,\"wage\":1,\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2025-09-28\"},\"10-01\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2025-10-01\"},\"10-02\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2025-10-02\"},\"10-03\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":3,\"date\":\"2025-10-03\"},\"10-04\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-04\"},\"10-05\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-05\"},\"10-06\":{\"holiday\":true,\"name\":\"\u4e2d\u79cb\u8282\",\"wage\":2,\"date\":\"2025-10-06\"},\"10-07\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-07\"},\"10-08\":{\"holiday\":true,\"name\":\"\u56fd\u5e86\u8282\",\"wage\":2,\"date\":\"2025-10-08\"},\"10-11\":{\"holiday\":false,\"after\":true,\"wage\":1,\"name\":\"\u56fd\u5e86\u8282\u540e\u8865\u73ed\",\"target\":\"\u56fd\u5e86\u8282\",\"date\":\"2025-10-11\"}}}";
    public static Date starYear = DateUtils.parseDate("2023-01-01");
    public static Date endYear = DateUtils.parseDate("2025-12-31");

    public static void main(String[] args) {
        Date date = DateUtils.parseDate("2025-01-24");
        Date date1 = HolidayUtils.addWorkDay(date, 15);
        System.out.println(sdf.format(date1));
        System.out.println(HolidayUtils.isWeekday(LocalDate.of(2024, 12, 21)));
    }

    public static void initData(Date starYear, Date endYear) {
        HolidayTemplate parse1 = (HolidayTemplate)JSON.parseObject((String)customHoliday2023, HolidayTemplate.class);
        HolidayTemplate parse2 = (HolidayTemplate)JSON.parseObject((String)customHoliday2024, HolidayTemplate.class);
        HolidayTemplate parse3 = (HolidayTemplate)JSON.parseObject((String)customHoliday2025, HolidayTemplate.class);
        ConcurrentHashMap holidayContentList = new ConcurrentHashMap();
        parse1.getHoliday().forEach((key, value) -> {
            LocalDate localDate = LocalDate.parse("2023-" + key);
            if (value.getHoliday().booleanValue()) {
                holidayList.add((Object)localDate);
            } else {
                supplementaryShiftList.add((Object)localDate);
            }
            holidayContentList.put(value.getDate(), value);
        });
        parse2.getHoliday().forEach((key, value) -> {
            LocalDate localDate = LocalDate.parse("2024-" + key);
            if (value.getHoliday().booleanValue()) {
                holidayList.add((Object)localDate);
            } else {
                supplementaryShiftList.add((Object)localDate);
            }
            holidayContentList.put(value.getDate(), value);
        });
        parse3.getHoliday().forEach((key, value) -> {
            LocalDate localDate = LocalDate.parse("2025-" + key);
            if (value.getHoliday().booleanValue()) {
                holidayList.add((Object)localDate);
            } else {
                supplementaryShiftList.add((Object)localDate);
            }
            holidayContentList.put(value.getDate(), value);
        });
        List allDateTimes = DateUtil.rangeToList((Date)DateUtil.beginOfYear((Date)starYear), (Date)DateUtil.endOfYear((Date)endYear), (DateField)DateField.DAY_OF_YEAR);
        ConcurrentHashMap allWeekend = allDateTimes.stream().filter(DateUtil::isWeekend).map(HolidayUtils::getWeekend).collect(Collectors.toMap(HolidayTemplate.content::getDate, weekend -> weekend, (a, b) -> b, ConcurrentHashMap::new));
        ConcurrentHashMap result = new ConcurrentHashMap();
        result.putAll(allWeekend);
        result.putAll(holidayContentList);
        List entryList = result.entrySet().stream().filter(e -> ((HolidayTemplate.content)e.getValue()).getHoliday()).sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
        Map<String, HolidayTemplate.content> collect = entryList.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        allHolidayContentList.putAll(collect);
        Set keySet = allHolidayContentList.keySet();
        allDateTimes.forEach(arg_0 -> HolidayUtils.lambda$initData$6((ConcurrentHashMap.KeySetView)keySet, arg_0));
    }

    public static HolidayTemplate.content getWeekend(DateTime date) {
        HolidayTemplate.content content2 = new HolidayTemplate.content();
        String format = sdf.format((Date)date);
        content2.setHoliday(true);
        content2.setName(date.dayOfWeekEnum().toChinese());
        content2.setDate(format);
        return content2;
    }

    public static Boolean isWeekday(LocalDate date) {
        if (holidayList.isEmpty() || supplementaryShiftList.isEmpty()) {
            throw new ServiceException("\u8282\u5047\u65e5\u6570\u636e\u52a0\u8f7d\u5f02\u5e38");
        }
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        return dayOfWeek != DayOfWeek.SATURDAY && dayOfWeek != DayOfWeek.SUNDAY && !holidayList.contains((Object)date) || (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) && supplementaryShiftList.contains((Object)date);
    }

    public static Boolean getDateIsHoliday(Date date) {
        if (date == null) {
            throw new RuntimeException("\u65f6\u95f4\u53c2\u6570\u4e3a\u7a7a");
        }
        if (date.before(starYear) || date.after(endYear)) {
            throw new RuntimeException("\u6682\u65e0\u5177\u4f53\u8282\u5047\u65e5\u4fe1\u606f");
        }
        return holidayCalendar.get(DateUtils.format(date, "yyyy-MM-dd"));
    }

    public static String getNextWorkDayString(Date inputDate) {
        String currentDateStr;
        if (inputDate == null) {
            inputDate = new Date();
        }
        String formatTime = DateUtils.format(inputDate, "HH:mm:ss");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(inputDate);
        calendar.add(6, 1);
        while (true) {
            if (holidayCalendar.containsKey(currentDateStr = dateFormat.format(calendar.getTime())) && !holidayCalendar.get(currentDateStr).booleanValue()) break;
            calendar.add(5, 1);
        }
        String result = currentDateStr;
        result = result + " " + formatTime;
        return result;
    }

    public static Date getNextWorkDayDate(Date inputDate) {
        String nextWorkDayString = HolidayUtils.getNextWorkDayString(inputDate);
        return DateUtils.parseDate(nextWorkDayString);
    }

    public static Date addWorkDay(Date date, int days) {
        if (date == null) {
            throw new RuntimeException("\u65f6\u95f4\u53c2\u6570\u4e3a\u7a7a");
        }
        Date tempDate = date;
        for (int i = 0; i < days; ++i) {
            tempDate = HolidayUtils.getNextWorkDayDate(tempDate);
        }
        return tempDate;
    }

    private static /* synthetic */ void lambda$initData$6(ConcurrentHashMap.KeySetView keySet, DateTime allDateTime) {
        if (keySet.contains(allDateTime.toString("yyyy-MM-dd"))) {
            holidayCalendar.put(allDateTime.toString("yyyy-MM-dd"), true);
        } else {
            holidayCalendar.put(allDateTime.toString("yyyy-MM-dd"), false);
        }
    }

    static {
        HolidayUtils.initData(starYear, endYear);
    }
}

