/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.passwordLog;

import cn.hutool.http.HttpUtil;
import cn.smarthse.common.util.passwordLog.IpUtils;
import cn.smarthse.common.util.passwordLog.StringUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressUtils {
    private static final Logger log = LoggerFactory.getLogger(AddressUtils.class);
    public static final String IP_URL = "http://whois.pconline.com.cn/ipJson.jsp";
    public static final String UNKNOWN = "XX XX";

    public static String getRealAddressByIP(String ip) {
        if (IpUtils.internalIp(ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("ip", ip);
            map.put("json", true);
            String rspStr = HttpUtil.get((String)IP_URL, map);
            if (StringUtils.isEmpty(rspStr)) {
                log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
                return UNKNOWN;
            }
            JSONObject obj = JSONObject.parseObject((String)rspStr);
            String region = obj.getString("pro");
            String city = obj.getString("city");
            return String.format("%s %s", region, city);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Throwable)e);
            return UNKNOWN;
        }
    }
}

