/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.number;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;
import java.util.Random;
import org.apache.commons.lang3.math.NumberUtils;

public class NumberUtil
extends NumberUtils {
    public static int getValueByMap(Map<String, Object> data, String key, int defaultValue) {
        int result = defaultValue;
        try {
            Object value = data.get(key);
            if (value != null) {
                result = NumberUtil.toInt((String)String.valueOf(value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int randomRange(int min, int max) {
        Random random = new Random();
        return random.nextInt(max) % (max - min + 1) + min;
    }

    public static String rateProcessing(int member, int denominator) {
        if (member == 0 || denominator == 0) {
            return "0.0%";
        }
        double num = (double)(member * 100) / (double)denominator;
        DecimalFormat df = new DecimalFormat("0.0");
        return df.format(num) + "%";
    }

    public static String rateProcessing1(int member, int denominator) {
        if (member == 0) {
            return "0.0%";
        }
        if (denominator == 0) {
            return "100.0%";
        }
        double num = (double)(member * 100) / (double)denominator;
        DecimalFormat df = new DecimalFormat("0.0");
        return df.format(num) + "%";
    }

    public static Double rateDouble(int member, int denominator) {
        if (member == 0) {
            return 0.0;
        }
        if (denominator == 0) {
            return 100.0;
        }
        BigDecimal b1 = new BigDecimal(member);
        BigDecimal b2 = new BigDecimal(denominator);
        return b1.divide(b2, 1, 4).doubleValue();
    }

    public static boolean isPositiveInteger(String num) {
        return num == null ? false : num.matches("^[1-9]\\d*$");
    }

    public static Number percent2Num(String value, double defaultValue) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        try {
            Number parse = numberFormat.parse(value);
            return parse;
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public static BigDecimal div(Number v1, Number v2, int scale, RoundingMode roundingMode) {
        if (v1 == null || v1.intValue() == 0 || v2 == null || v2.intValue() == 0) {
            return new BigDecimal("0");
        }
        return cn.hutool.core.util.NumberUtil.div((Number)v1, (Number)v2, (int)scale, (RoundingMode)roundingMode);
    }

    public static BigDecimal customDivReturnBigDecimal(Integer v1, Integer v2) {
        return NumberUtil.customDivReturnBigDecimal(v1, v2, 4);
    }

    public static BigDecimal customDivReturnBigDecimal(Integer v1, Integer v2, int scale) {
        if (v2 == null || v2 == 0) {
            return null;
        }
        if (v1 == null || v1 == 0) {
            return new BigDecimal("0.00");
        }
        return cn.hutool.core.util.NumberUtil.div((Number)v1, (Number)v2, (int)scale).movePointRight(2);
    }

    public static String customDivReturnString(Integer v1, Integer v2) {
        return NumberUtil.customDivReturnString(v1, v2, 4);
    }

    public static String customDivReturnString(Integer v1, Integer v2, int scale) {
        if (v2 == null || v2 == 0) {
            return "-";
        }
        if (v1 == null || v1 == 0) {
            return "0.00%";
        }
        return cn.hutool.core.util.NumberUtil.formatPercent((double)cn.hutool.core.util.NumberUtil.div((Number)v1, (Number)v2, (int)scale).doubleValue(), (int)scale);
    }
}

