/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.number;

import cn.smarthse.common.util.number.Tool;

public class NumberChangeToChinese {
    private static final String TEN_NUM = "\u4e00\u5341";

    private NumberChangeToChinese() {
    }

    public static final NumberChangeToChinese getInstance() {
        return lazyHolder.NCTC;
    }

    public String numberToChinese(int num) {
        if (num == 0) {
            return "\u96f6";
        }
        int unitPos = 0;
        String numberStr = new String();
        String chineseNum = new String();
        boolean needZero = false;
        String strIns = new String();
        while (num > 0) {
            int section = num % 10000;
            if (needZero) {
                numberStr = Tool.chnNumChar[0] + numberStr;
            }
            chineseNum = this.sectionTOChinese(section, chineseNum);
            if (section != 0) {
                strIns = Tool.chnUnitSection[unitPos];
                chineseNum = chineseNum + strIns;
            } else {
                strIns = Tool.chnUnitSection[0];
                chineseNum = strIns + chineseNum;
            }
            numberStr = chineseNum + numberStr;
            chineseNum = "";
            needZero = section < 1000 && section > 0;
            num /= 10000;
            ++unitPos;
        }
        if (numberStr.startsWith(TEN_NUM)) {
            numberStr = numberStr.replaceFirst(TEN_NUM, "\u5341");
        }
        return numberStr;
    }

    private String sectionTOChinese(int section, String chineseNum) {
        String setionChinese = new String();
        int unitPos = 0;
        boolean zero = true;
        while (section > 0) {
            int v = section % 10;
            if (v == 0) {
                if (!zero) {
                    zero = true;
                    chineseNum = Tool.chnNumChar[0] + chineseNum;
                }
            } else {
                zero = false;
                setionChinese = Tool.chnNumChar[v];
                setionChinese = setionChinese + Tool.chnUnitChar[unitPos];
                chineseNum = setionChinese + chineseNum;
            }
            ++unitPos;
            section /= 10;
        }
        return chineseNum;
    }

    private static class lazyHolder {
        private static final NumberChangeToChinese NCTC = new NumberChangeToChinese();

        private lazyHolder() {
        }
    }
}

