/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.excel;

import cn.smarthse.common.annotation.excel.ColMetaData;
import cn.smarthse.common.annotation.excel.ExcelErrorInfoVo;
import cn.smarthse.common.annotation.excel.ExcelFormatterValid;
import cn.smarthse.common.annotation.excel.ExcelValid;
import cn.smarthse.common.annotation.excel.ImportCol;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelRowContent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ExcelValidUtils<T> {
    private static <T> Map<String, Map<Field, String>> getAllFieldColNameMap(T t) {
        Field[] fields = t.getClass().getDeclaredFields();
        List finalList = Arrays.stream(fields).filter(s -> {
            ImportCol importCol = s.getAnnotation(ImportCol.class);
            return importCol != null;
        }).collect(Collectors.toList());
        HashMap<String, Map<Field, String>> map = new HashMap<String, Map<Field, String>>();
        for (Field field : finalList) {
            ImportCol importCol = field.getAnnotation(ImportCol.class);
            ColMetaData[] colMetaDatas = importCol.colMetaData();
            if (colMetaDatas == null || colMetaDatas.length == 0) continue;
            for (ColMetaData colMetaData : colMetaDatas) {
                if (map.get(colMetaData.sheetName()) == null) {
                    map.put(colMetaData.sheetName(), new HashMap());
                }
                ((Map)map.get(colMetaData.sheetName())).put(field, colMetaData.colName());
            }
        }
        return map;
    }

    public static <T> List<ExcelErrorInfoVo> getValidMessages(List<ExcelRowContent<T>> list, String sheetName) throws Exception {
        ArrayList<ExcelErrorInfoVo> results = new ArrayList<ExcelErrorInfoVo>();
        if (list == null || list.size() == 0) {
            ExcelErrorInfoVo vo = new ExcelErrorInfoVo();
            vo.setRowNo(0L);
            vo.setSheetName(sheetName);
            vo.setErrMsg("excel\u5de5\u4f5c\u8868\u4e3a\u7a7a");
            results.add(vo);
        }
        Object t = null;
        Field[] fields = null;
        Map<Field, String> fieldColNameMap = null;
        for (ExcelRowContent<T> rowContent : list) {
            t = rowContent.getT();
            if (fields == null) {
                fields = t.getClass().getDeclaredFields();
                fieldColNameMap = ExcelValidUtils.getAllFieldColNameMap(t).get(rowContent.getSheetName());
            }
            for (Field field : fields) {
                Pattern pattern;
                Matcher matcher;
                ExcelValid valid = field.getAnnotation(ExcelValid.class);
                ImportCol importCol = field.getAnnotation(ImportCol.class);
                ColMetaData[] colMetaDatas = null;
                if (importCol != null) {
                    colMetaDatas = importCol.colMetaData();
                }
                if (valid == null || colMetaDatas.length <= 0 || Arrays.stream(colMetaDatas).filter(s -> s.sheetName().equals(sheetName)).findAny().orElse(null) == null) continue;
                String getMethodName = "get" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
                Method getMethod = t.getClass().getMethod(getMethodName, new Class[0]);
                Object value = getMethod.invoke(t, new Object[0]);
                ExcelErrorInfoVo vo = new ExcelErrorInfoVo();
                if (value == null || StringUtils.isEmpty((CharSequence)value.toString())) {
                    vo.setColName(fieldColNameMap.get(field));
                    vo.setRowNo(rowContent.getRowNum());
                    vo.setSheetName(rowContent.getSheetName());
                    vo.setErrMsg(valid.errMsg()[0]);
                    results.add(vo);
                    continue;
                }
                ExcelFormatterValid formatterValid = field.getAnnotation(ExcelFormatterValid.class);
                if (formatterValid == null || (matcher = (pattern = Pattern.compile(formatterValid.regexExp())).matcher(value.toString())).matches()) continue;
                vo.setColName(fieldColNameMap.get(field));
                vo.setRowNo(rowContent.getRowNum());
                vo.setSheetName(rowContent.getSheetName());
                vo.setErrMsg(formatterValid.errMsg()[0]);
                results.add(vo);
            }
        }
        return results;
    }
}

