/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.excel;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.DateUtils;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelContent;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelUtil {
    private ExcelUtil() {
    }

    public static final ExcelUtil getInstance() {
        return new ExcelUtil();
    }

    public static void verticalMerged(Workbook book, int sheetAt, int startIndex, int Col) {
        Sheet sheet = book.getSheetAt(sheetAt);
        int totalRow = ExcelUtil.getRowNum(sheet, Col);
        String beforeText = "";
        int startRow = 0;
        for (int i = startIndex; i < totalRow; ++i) {
            CellRangeAddress region;
            Row row = sheet.getRow(i);
            if (row == null || row.getCell(Col) == null) continue;
            String text = row.getCell(Col).getStringCellValue();
            if ("".equals(beforeText)) {
                beforeText = text;
                startRow = i;
                continue;
            }
            if (!beforeText.equals(text)) {
                if (startRow != i && startRow != i - 1) {
                    region = new CellRangeAddress(startRow, i - 1, Col, Col);
                    sheet.addMergedRegion(region);
                }
                startRow = i;
                beforeText = text;
                continue;
            }
            if (i != totalRow - 1 || startRow == i || ExcelUtil.isMergedRegion(sheet, i, Col)) continue;
            region = new CellRangeAddress(startRow, i, Col, Col);
            sheet.addMergedRegion(region);
        }
    }

    public static void verticalMerged(Workbook book, int sheetAt, int startIndex, int Col, int Colexp) {
        Sheet sheet = book.getSheetAt(sheetAt);
        int totalRow = ExcelUtil.getRowNum(sheet, Col);
        String beforeText = "";
        String expText = "";
        int startRow = 0;
        for (int i = startIndex; i < totalRow; ++i) {
            CellRangeAddress region;
            Row row = sheet.getRow(i);
            if (row == null || row.getCell(Col) == null || row.getCell(Colexp) == null) continue;
            String text = row.getCell(Col).getStringCellValue();
            String expText2 = row.getCell(Colexp).getStringCellValue();
            if ("".equals(beforeText)) {
                beforeText = text;
                startRow = i;
                expText = expText2;
                continue;
            }
            if (!beforeText.equals(text) || !expText.equals(expText2)) {
                if (startRow != i && startRow != i - 1) {
                    region = new CellRangeAddress(startRow, i - 1, Col, Col);
                    sheet.addMergedRegion(region);
                }
                startRow = i;
                beforeText = text;
                expText = expText2;
                continue;
            }
            if (i != totalRow - 1 || startRow == i || ExcelUtil.isMergedRegion(sheet, i, Col)) continue;
            region = new CellRangeAddress(startRow, i, Col, Col);
            sheet.addMergedRegion(region);
        }
    }

    private static boolean isMergedRegion(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            int firstColumn = range.getFirstColumn();
            int lastColumn = range.getLastColumn();
            int firstRow = range.getFirstRow();
            int lastRow = range.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            return true;
        }
        return false;
    }

    private static int getRowNum(Sheet sheet, int Col) {
        Iterator iRow = sheet.iterator();
        int i = 0;
        while (iRow.hasNext()) {
            Row row = (Row)iRow.next();
            if (row == null || row.getCell(Col) == null) continue;
            ++i;
        }
        return i;
    }

    public List<List<List<String>>> getContent(String filePath, List<Integer> cellNum) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<List<String>>> content2 = new ArrayList<List<List<String>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            ArrayList sheetContent = new ArrayList();
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty) continue;
                sheetContent.add(rowContent);
            }
            content2.add(sheetContent);
        }
        return content2;
    }

    public List<List<List<String>>> getContent(String filePath, List<Integer> cellNum, Integer col) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<List<String>>> content2 = new ArrayList<List<List<String>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            int j;
            sheet = hwb.getSheetAt(i);
            ArrayList sheetContent = new ArrayList();
            int n = j = col >= 1 ? col : 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c;
                    HSSFCell cell = row.getCell(k);
                    if (cell != null) {
                        cell.setCellType(CellType.STRING);
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (!isAllEmpty) {
                    sheetContent.add(rowContent);
                }
                ++j;
            }
            content2.add(sheetContent);
        }
        return content2;
    }

    public Map<String, ArrayList<ArrayList<String>>> getContentFromUrl(String urlPath, List<Integer> cellValidNumList, List<Integer> colValidNumList) throws Exception {
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            return null;
        }
        InputStream in = this.getOssInputStream(urlPath);
        return this.getContentFromInputStream(in, cellValidNumList, colValidNumList);
    }

    private Map<String, ArrayList<ArrayList<String>>> getContentFromInputStream(InputStream fis, List<Integer> cellValidNumList, List<Integer> colValidNumList) throws Exception {
        if (cellValidNumList == null || cellValidNumList.isEmpty() || colValidNumList == null || colValidNumList.isEmpty()) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFRow row = null;
        HashMap<String, ArrayList<ArrayList<String>>> contentMap = new HashMap<String, ArrayList<ArrayList<String>>>();
        int sheetNum = 0;
        sheetNum = cellValidNumList.size() > colValidNumList.size() ? colValidNumList.size() : cellValidNumList.size();
        for (int i = 0; i < hwb.getNumberOfSheets() && i != sheetNum; ++i) {
            int j;
            HSSFSheet sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            Integer col = colValidNumList.get(i);
            if (col == null) continue;
            int n = j = col >= 0 ? col : 0;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                Integer cellNum = cellValidNumList.get(i);
                if (row != null) {
                    for (int k = cellNum.intValue(); k < row.getLastCellNum(); ++k) {
                        String c;
                        HSSFCell cell = row.getCell(k);
                        if (cell == null) {
                            rowContent.add("");
                            continue;
                        }
                        if (cell != null) {
                            cell.setCellType(CellType.STRING);
                        }
                        String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                        if (c == null) {
                            c = "";
                        }
                        if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                            isAllEmpty = false;
                        }
                        rowContent.add(c);
                    }
                }
                if (!isAllEmpty) {
                    ((ArrayList)contentMap.get(sheet.getSheetName())).add(rowContent);
                }
                ++j;
            }
        }
        return contentMap;
    }

    public Map<String, ArrayList<ArrayList<String>>> getContent(String filePath, List<Integer> cellValidNumList, List<Integer> colValidNumList) throws Exception {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        return this.getContentFromInputStream(fis, cellValidNumList, colValidNumList);
    }

    public List<List<String>> getContent1(String filePath, List<Integer> cellNum) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    public List<List<String>> getContent2(InputStream fis, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (fis == null) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    public List<List<String>> getContent3(InputStream fis, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (fis == null) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    public List<List<String>> getContent3(String filePath, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    private String getCellValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        String value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case NUMERIC: {
                long dd = (long)cell.getNumericCellValue();
                value = dd + "";
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case FORMULA: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
        }
        return value;
    }

    private String getCellValue1(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        String value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case NUMERIC: {
                value = this.parseExcel(cell);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case FORMULA: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
        }
        return value;
    }

    public static Date getDate(Cell cell) {
        String dateStr;
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return cell.getDateCellValue();
        }
        if (cell.getCellType() == CellType.STRING && StringUtils.isNotEmpty(dateStr = cell.getStringCellValue())) {
            Date date = null;
            try {
                date = DateFormat.getDateInstance().parse(dateStr.trim());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }
        return null;
    }

    private String parseExcel(HSSFCell cell) {
        String result = "";
        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
            SimpleDateFormat sdf = null;
            sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
            Date date = cell.getDateCellValue();
            result = sdf.format(date);
        } else if (cell.getCellStyle().getDataFormat() == 58) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            double value = cell.getNumericCellValue();
            Date date = DateUtil.getJavaDate((double)value);
            result = sdf.format(date);
        } else {
            double value = cell.getNumericCellValue();
            HSSFCellStyle style = cell.getCellStyle();
            DecimalFormat format = new DecimalFormat();
            String temp = style.getDataFormatString();
            if (temp.equals("General")) {
                format.applyPattern("#");
            }
            result = format.format(value);
        }
        return result;
    }

    public InputStream getOssInputStream(String urlPath) {
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            return null;
        }
        if (!urlPath.startsWith("http") && !urlPath.startsWith("https")) {
            return null;
        }
        InputStream in = null;
        try {
            Cookie[] cookies;
            HttpServletRequest request;
            HttpResponse execute = HttpUtil.createGet((String)urlPath).execute();
            in = execute.bodyStream();
            OssClientBean ossclient = SpringContextHolder.getBean(OssClientBean.class);
            if (!(ossclient != null && ossclient.isAsynch() || (request = ServletsUtil.getRequest()) == null || (cookies = request.getCookies()) == null || cookies.length <= 0)) {
                StringBuffer sb = new StringBuffer();
                for (Cookie cookie : cookies) {
                    String cname = cookie.getName();
                    String cvalue = cookie.getValue();
                    sb.append(cname + "=" + cvalue + ";");
                    if (!"smarthse.hid".equals(cname)) continue;
                    sb.append("JSESSIONID=" + cvalue + ";");
                }
            }
            return in;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void downExcelBySheetNames(String filePath, List<String> sheetNames, OutputStream out) throws Exception {
        ArrayList<String> noNeedSheetNames = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            noNeedSheetNames.add(hwb.getSheetAt(i).getSheetName());
        }
        if (sheetNames != null && sheetNames.size() > 0) {
            for (String name : sheetNames) {
                noNeedSheetNames.remove(name);
            }
        }
        if (noNeedSheetNames != null && noNeedSheetNames.size() > 0) {
            for (String name : noNeedSheetNames) {
                hwb.removeSheetAt(hwb.getSheetIndex(name));
            }
        }
        hwb.setSelectedTab(0);
        hwb.setFirstVisibleTab(0);
        hwb.setActiveSheet(0);
        hwb.write(out);
        hwb.close();
    }

    public Map<String, ArrayList<ArrayList<String>>> getContent(String filePath, Map<String, Integer> validColMap, Map<String, Integer> startRowMap) throws Exception {
        InputStream fis = this.getOssInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        HashMap<String, ArrayList<ArrayList<String>>> contentMap = new HashMap<String, ArrayList<ArrayList<String>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            int j;
            sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            Integer startRow = startRowMap.get(sheet.getSheetName());
            if (startRow == null) continue;
            int n = j = startRow >= 1 ? startRow : 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                Integer cellNum = validColMap.get(sheet.getSheetName());
                for (int k = 0; k < cellNum; ++k) {
                    String c;
                    HSSFCell cell = row.getCell(k);
                    if (cell != null) {
                        cell.setCellType(CellType.STRING);
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (StringUtils.isEmpty((CharSequence)c) && StringUtils.isNotEmpty(ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k))) {
                        c = ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k);
                    }
                    if (StringUtils.isEmpty((CharSequence)c)) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (!isAllEmpty) {
                    ((ArrayList)contentMap.get(sheet.getSheetName())).add(rowContent);
                }
                ++j;
            }
        }
        hwb.close();
        return contentMap;
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return fCell.getStringCellValue();
        }
        return null;
    }

    public Map<String, ArrayList<ArrayList<ExcelContent>>> getContentHasExcelInfo(String filePath, Map<String, Integer> validColMap, Map<String, Integer> startRowMap) throws Exception {
        InputStream fis = this.getOssInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        HashMap<String, ArrayList<ArrayList<ExcelContent>>> contentMap = new HashMap<String, ArrayList<ArrayList<ExcelContent>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            int j;
            sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            Integer startRow = startRowMap.get(sheet.getSheetName());
            if (startRow == null) continue;
            int n = j = startRow >= 1 ? startRow : 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                if (row != null) {
                    ArrayList<ExcelContent> rowContent = new ArrayList<ExcelContent>();
                    boolean isAllEmpty = true;
                    Integer cellNum = validColMap.get(sheet.getSheetName());
                    for (int k = 0; k < cellNum; ++k) {
                        String c;
                        HSSFCell cell = row.getCell(k);
                        if (cell != null) {
                            cell.setCellType(CellType.STRING);
                        }
                        String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                        if (StringUtils.isEmpty((CharSequence)c) && StringUtils.isNotEmpty(ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k))) {
                            c = ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k);
                        }
                        if (StringUtils.isEmpty((CharSequence)c)) {
                            c = "";
                        }
                        if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                            isAllEmpty = false;
                        }
                        ExcelContent content2 = new ExcelContent();
                        content2.setRowNum(Long.valueOf(j + 1));
                        content2.setSheetName(sheet.getSheetName());
                        content2.setContent(c);
                        rowContent.add(content2);
                    }
                    if (!isAllEmpty) {
                        ((ArrayList)contentMap.get(sheet.getSheetName())).add(rowContent);
                    }
                }
                ++j;
            }
        }
        hwb.close();
        return contentMap;
    }

    public void downExcelByColTittleNames(String filePath, List<String> colTittleNames, Integer startRow, Integer startCol, OutputStream out) throws Exception {
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = sheet.getRow(startRow.intValue());
        for (int i = 0; i < colTittleNames.size(); ++i) {
            row.createCell(i + startCol).setCellValue(colTittleNames.get(i));
            sheet.autoSizeColumn(i + startCol);
        }
        hwb.write(out);
        hwb.close();
    }

    public List<List<String>> getContentByCell(InputStream fis, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (fis == null) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < cellNum.size(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    public List<List<String>> getAllContentByCell(InputStream fis, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (fis == null) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < cellNum.size(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    HSSFCell cell = row.getCell(k);
                    String c = "";
                    if (cell != null) {
                        cell.setCellType(CellType.STRING);
                        c = cell.getStringCellValue().trim();
                    }
                    if (StringUtils.isNotEmpty(c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    public List<List<ExcelContent>> getSingleExcelContentHasExcelInfo(String filePath, Integer validCol, Integer startRow, Map<Integer, CellType> colTypeMap) throws Exception {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return Collections.emptyList();
        }
        if (filePath.lastIndexOf(".xlsx") > 0 && ".xlsx".equals(filePath.substring(filePath.lastIndexOf(".xlsx"), filePath.length()))) {
            return this.getSingleExcelContentHasExcelInfo2007(filePath, validCol, startRow, colTypeMap);
        }
        if (filePath.lastIndexOf(".xls") > 0 && ".xls".equals(filePath.substring(filePath.lastIndexOf(".xls"), filePath.length()))) {
            return this.getSingleExcelContentHasExcelInfo2003(filePath, validCol, startRow);
        }
        return Collections.emptyList();
    }

    public List<List<ExcelContent>> getSingleExcelContentHasExcelInfo2003(String filePath, Integer validCol, Integer startRow) throws Exception {
        int j;
        InputStream fis = this.getOssInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        String sheetName = sheet.getSheetName();
        HSSFRow row = null;
        ArrayList<List<ExcelContent>> contentList = new ArrayList<List<ExcelContent>>();
        int n = j = startRow >= 1 ? startRow : 1;
        while (j < sheet.getPhysicalNumberOfRows()) {
            row = sheet.getRow(j);
            ArrayList<ExcelContent> rowContent = new ArrayList<ExcelContent>();
            boolean isAllEmpty = true;
            for (int k = 0; k < validCol; ++k) {
                String c;
                HSSFCell cell = row.getCell(k);
                if (cell != null) {
                    cell.setCellType(CellType.STRING);
                }
                String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                if (StringUtils.isEmpty((CharSequence)c) && StringUtils.isNotEmpty(ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k))) {
                    c = ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k);
                }
                if (StringUtils.isEmpty((CharSequence)c)) {
                    c = "";
                }
                if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                    isAllEmpty = false;
                }
                ExcelContent content2 = new ExcelContent();
                content2.setRowNum(Long.valueOf(j + 1));
                content2.setSheetName(sheetName);
                content2.setContent(c);
                rowContent.add(content2);
            }
            if (!isAllEmpty) {
                contentList.add(rowContent);
            }
            ++j;
        }
        hwb.close();
        return contentList;
    }

    public List<List<ExcelContent>> getSingleExcelContentHasExcelInfo2007(String filePath, Integer validCol, Integer startRow, Map<Integer, CellType> colTypeMap) throws Exception {
        int j;
        InputStream fis = this.getOssInputStream(filePath);
        XSSFWorkbook hwb = new XSSFWorkbook(fis);
        XSSFSheet sheet = hwb.getSheetAt(0);
        String sheetName = sheet.getSheetName();
        XSSFRow row = null;
        ArrayList<List<ExcelContent>> contentList = new ArrayList<List<ExcelContent>>();
        int n = j = startRow >= 1 ? startRow : 1;
        while (j < sheet.getPhysicalNumberOfRows()) {
            row = sheet.getRow(j);
            if (row != null) {
                ArrayList<ExcelContent> rowContent = new ArrayList<ExcelContent>();
                boolean isAllEmpty = true;
                for (int k = 0; k < validCol; ++k) {
                    String c;
                    XSSFCell cell = row.getCell(k);
                    if (cell != null) {
                        if (colTypeMap != null && colTypeMap.get(k) == CellType.STRING) {
                            cell.setCellType(CellType.STRING);
                        } else if (cell.getCellTypeEnum() == CellType.NUMERIC && DateUtil.isValidExcelDate((double)cell.getNumericCellValue())) {
                            String date = null;
                            date = new BigDecimal(cell.getNumericCellValue()).toPlainString().length() == 8 ? DateUtils.format(DateUtils.parseDate((String)new BigDecimal(cell.getNumericCellValue()).toPlainString(), (String[])new String[]{"yyyyMMdd"}), "yyyy-MM-dd") : DateUtils.format(cell.getDateCellValue(), "yyyy-MM-dd");
                            cell.setCellValue(date);
                        } else {
                            cell.setCellType(CellType.STRING);
                        }
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (StringUtils.isEmpty((CharSequence)c) && StringUtils.isNotEmpty(ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k))) {
                        c = ExcelUtil.getMergedRegionValue((Sheet)sheet, j, k);
                    }
                    if (StringUtils.isEmpty((CharSequence)c)) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    ExcelContent content2 = new ExcelContent();
                    content2.setRowNum(Long.valueOf(j + 1));
                    content2.setSheetName(sheetName);
                    content2.setContent(c);
                    rowContent.add(content2);
                }
                if (!isAllEmpty) {
                    contentList.add(rowContent);
                }
            }
            ++j;
        }
        hwb.close();
        return contentList;
    }

    public List<List<String>> getContent4(InputStream fis, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (fis == null) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content2 = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets() && i < cellNum.size(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue2(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c.trim());
                }
                if (isAllEmpty) continue;
                rowContent.add(sheetName);
                content2.add(rowContent);
            }
        }
        return content2;
    }

    private String getCellValue2(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        String value = null;
        switch (cell.getCellType()) {
            case STRING: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case NUMERIC: {
                value = this.parseExcel1(cell);
                break;
            }
            case BLANK: {
                value = "";
                break;
            }
            case FORMULA: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
        }
        return value;
    }

    private String parseExcel1(HSSFCell cell) {
        String result = "";
        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
            SimpleDateFormat sdf = null;
            sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
            Date date = cell.getDateCellValue();
            result = sdf.format(date);
        } else if (cell.getCellStyle().getDataFormat() == 58) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            double value = cell.getNumericCellValue();
            Date date = DateUtil.getJavaDate((double)value);
            result = sdf.format(date);
        } else {
            double value = cell.getNumericCellValue();
            HSSFCellStyle style = cell.getCellStyle();
            DecimalFormat format = new DecimalFormat();
            result = format.format(value);
        }
        return result;
    }
}

