/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.excel;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.annotation.excel.ColMetaData;
import cn.smarthse.common.annotation.excel.ImportCol;
import cn.smarthse.common.annotation.excel.SheetInfoVo;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelRowContent;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class ExcelImportUtilsV308<T> {
    public static Map<String, Map<Integer, Field>> getAllField(Class clazz) {
        Field[] fields = clazz.getDeclaredFields();
        List finalList = Arrays.stream(fields).filter(s -> {
            ImportCol importCol = s.getAnnotation(ImportCol.class);
            return importCol != null;
        }).collect(Collectors.toList());
        HashMap<String, Map<Integer, Field>> map = new HashMap<String, Map<Integer, Field>>();
        for (Field field : finalList) {
            ImportCol importCol = field.getAnnotation(ImportCol.class);
            ColMetaData[] colMetaDatas = importCol.colMetaData();
            if (colMetaDatas == null || colMetaDatas.length == 0) continue;
            for (ColMetaData colMetaData : colMetaDatas) {
                if (map.get(colMetaData.sheetName()) == null) {
                    map.put(colMetaData.sheetName(), new HashMap());
                }
                ((Map)map.get(colMetaData.sheetName())).put(colMetaData.colIndex(), field);
            }
        }
        return map;
    }

    public <T> Map<String, List<ExcelRowContent<T>>> getContentHasExcelInfo(String filePath) throws Exception {
        HashMap<String, List<ExcelRowContent<T>>> contentMap = new HashMap<String, List<ExcelRowContent<T>>>();
        List<SheetInfoVo> sheetInfoVos = this.getSHeetInfoVos();
        if (sheetInfoVos == null || sheetInfoVos.size() == 0) {
            return contentMap;
        }
        HashMap sheetInfoVoMap = new HashMap();
        sheetInfoVos.forEach(s -> sheetInfoVoMap.put(s.getSheetName(), s));
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)pt.getActualTypeArguments()[0];
        Map<String, Map<Integer, Field>> sheetNameFieldMap = ExcelImportUtilsV308.getAllField(clazz);
        InputStream fis = ExcelImportUtilsV308.getOssInputStream(filePath);
        XSSFWorkbook hwb = new XSSFWorkbook(fis);
        XSSFSheet sheet = hwb.getSheetAt(0);
        XSSFRow row = null;
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            Integer startRow;
            sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            SheetInfoVo sheetInfoVo = (SheetInfoVo)sheetInfoVoMap.get(sheet.getSheetName());
            Map<Integer, Field> fieldMap = sheetNameFieldMap.get(sheet.getSheetName());
            if (sheetInfoVo == null || fieldMap == null || (startRow = Integer.valueOf(sheetInfoVo.getStartRowNum())) == null || startRow == 0) continue;
            for (int j = startRow - 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                row = sheet.getRow(j);
                if (row == null) continue;
                ExcelRowContent rowContent = new ExcelRowContent();
                rowContent.setT(clazz.newInstance());
                boolean isAllEmpty = true;
                Integer cellNum = sheetInfoVo.getColCount();
                for (int k = 0; k < cellNum; ++k) {
                    String c;
                    XSSFCell cell = row.getCell(k);
                    if (cell != null) {
                        cell.setCellType(CellType.STRING);
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (StringUtils.isEmpty((CharSequence)c) && StringUtils.isNotEmpty(ExcelImportUtilsV308.getMergedRegionValue((Sheet)sheet, j, k))) {
                        c = ExcelImportUtilsV308.getMergedRegionValue((Sheet)sheet, j, k);
                    }
                    if (StringUtils.isEmpty((CharSequence)c)) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        Object[] objectArray;
                        Class[] classArray;
                        isAllEmpty = false;
                        Field field = fieldMap.get(k);
                        if (field == null) continue;
                        String fieldName = field.getName();
                        String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                        Class<?> clazz2 = rowContent.getT().getClass();
                        if (fieldName.equals("id")) {
                            Class[] classArray2 = new Class[1];
                            classArray = classArray2;
                            classArray2[0] = Long.class;
                        } else {
                            Class[] classArray3 = new Class[1];
                            classArray = classArray3;
                            classArray3[0] = String.class;
                        }
                        Method setMethod = clazz2.getMethod(setMethodName, classArray);
                        Object t = rowContent.getT();
                        if (fieldName.equals("id")) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = Long.valueOf(c);
                        } else {
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = c;
                        }
                        Object object = setMethod.invoke(t, objectArray);
                    }
                    rowContent.setSheetName(sheet.getSheetName());
                    rowContent.setRowNum(Long.valueOf(j + 1));
                }
                if (isAllEmpty) continue;
                ((List)contentMap.get(sheet.getSheetName())).add(rowContent);
            }
        }
        hwb.close();
        return contentMap;
    }

    public static InputStream getOssInputStream(String urlPath) {
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            return null;
        }
        if (!urlPath.startsWith("http") && !urlPath.startsWith("https")) {
            return null;
        }
        InputStream in = null;
        try {
            Cookie[] cookies;
            HttpServletRequest request;
            HttpResponse execute = HttpUtil.createGet((String)urlPath).execute();
            in = execute.bodyStream();
            OssClientBean ossclient = SpringContextHolder.getBean(OssClientBean.class);
            if (!(ossclient != null && ossclient.isAsynch() || (request = ServletsUtil.getRequest()) == null || (cookies = request.getCookies()) == null || cookies.length <= 0)) {
                StringBuffer sb = new StringBuffer();
                for (Cookie cookie : cookies) {
                    String cname = cookie.getName();
                    String cvalue = cookie.getValue();
                    sb.append(cname + "=" + cvalue + ";");
                    if (!"smarthse.hid".equals(cname)) continue;
                    sb.append("JSESSIONID=" + cvalue + ";");
                }
            }
            return in;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return fCell.getStringCellValue();
        }
        return null;
    }

    protected abstract List<SheetInfoVo> getSHeetInfoVos();
}

