/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.excel;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.framework.beans.OssClientBean;
import cn.smarthse.common.util.ServletsUtil;
import cn.smarthse.common.util.SpringContextHolder;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.excel.ExcelRowContent;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class ExcelImportUtils<T> {
    public <T> Map<String, List<ExcelRowContent<T>>> getContentHasExcelInfo(String filePath, Map<String, Integer> validColMap, Map<String, Integer> startRowMap, Map<String, String[]> attrMap) throws Exception {
        ParameterizedType pt = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class clazz = (Class)pt.getActualTypeArguments()[0];
        Map<String, Field> fieldMap = ExcelImportUtils.getAllField(clazz);
        InputStream fis = ExcelImportUtils.getOssInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        HashMap<String, List<ExcelRowContent<T>>> contentMap = new HashMap<String, List<ExcelRowContent<T>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            int j;
            sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            Integer startRow = startRowMap.get(sheet.getSheetName());
            if (startRow == null) continue;
            int n = j = startRow >= 1 ? startRow : 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                if (row != null) {
                    ExcelRowContent rowContent = new ExcelRowContent();
                    rowContent.setT(clazz.newInstance());
                    boolean isAllEmpty = true;
                    Integer cellNum = validColMap.get(sheet.getSheetName());
                    for (int k = 0; k < cellNum; ++k) {
                        String c;
                        HSSFCell cell = row.getCell(k);
                        if (cell != null) {
                            cell.setCellType(CellType.STRING);
                        }
                        String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                        if (StringUtils.isEmpty((CharSequence)c) && StringUtils.isNotEmpty(ExcelImportUtils.getMergedRegionValue((Sheet)sheet, j, k))) {
                            c = ExcelImportUtils.getMergedRegionValue((Sheet)sheet, j, k);
                        }
                        if (StringUtils.isEmpty((CharSequence)c)) {
                            c = "";
                        }
                        if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                            Object[] objectArray;
                            Class[] classArray;
                            isAllEmpty = false;
                            Field field = fieldMap.get(attrMap.get(sheet.getSheetName())[k]);
                            String fieldName = field.getName();
                            String setMethodName = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                            Class<?> clazz2 = rowContent.getT().getClass();
                            if (fieldName.equals("id")) {
                                Class[] classArray2 = new Class[1];
                                classArray = classArray2;
                                classArray2[0] = Long.class;
                            } else {
                                Class[] classArray3 = new Class[1];
                                classArray = classArray3;
                                classArray3[0] = String.class;
                            }
                            Method setMethod = clazz2.getMethod(setMethodName, classArray);
                            Object t = rowContent.getT();
                            if (fieldName.equals("id")) {
                                Object[] objectArray2 = new Object[1];
                                objectArray = objectArray2;
                                objectArray2[0] = Long.valueOf(c);
                            } else {
                                Object[] objectArray3 = new Object[1];
                                objectArray = objectArray3;
                                objectArray3[0] = c;
                            }
                            Object object = setMethod.invoke(t, objectArray);
                        }
                        rowContent.setRowNum(Long.valueOf(j + 1));
                    }
                    if (!isAllEmpty) {
                        ((List)contentMap.get(sheet.getSheetName())).add(rowContent);
                    }
                }
                ++j;
            }
        }
        hwb.close();
        return contentMap;
    }

    public static InputStream getOssInputStream(String urlPath) {
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            return null;
        }
        if (!urlPath.startsWith("http") && !urlPath.startsWith("https")) {
            return null;
        }
        InputStream in = null;
        try {
            Cookie[] cookies;
            HttpServletRequest request;
            HttpResponse execute = HttpUtil.createGet((String)urlPath).execute();
            in = execute.bodyStream();
            OssClientBean ossclient = SpringContextHolder.getBean(OssClientBean.class);
            if (!(ossclient != null && ossclient.isAsynch() || (request = ServletsUtil.getRequest()) == null || (cookies = request.getCookies()) == null || cookies.length <= 0)) {
                StringBuffer sb = new StringBuffer();
                for (Cookie cookie : cookies) {
                    String cname = cookie.getName();
                    String cvalue = cookie.getValue();
                    sb.append(cname + "=" + cvalue + ";");
                    if (!"smarthse.hid".equals(cname)) continue;
                    sb.append("JSESSIONID=" + cvalue + ";");
                }
            }
            return in;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getMergedRegionValue(Sheet sheet, int row, int column) {
        int sheetMergeCount = sheet.getNumMergedRegions();
        for (int i = 0; i < sheetMergeCount; ++i) {
            CellRangeAddress ca = sheet.getMergedRegion(i);
            int firstColumn = ca.getFirstColumn();
            int lastColumn = ca.getLastColumn();
            int firstRow = ca.getFirstRow();
            int lastRow = ca.getLastRow();
            if (row < firstRow || row > lastRow || column < firstColumn || column > lastColumn) continue;
            Row fRow = sheet.getRow(firstRow);
            Cell fCell = fRow.getCell(firstColumn);
            return fCell.getStringCellValue();
        }
        return null;
    }

    private static Map<String, Field> getAllField(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null) {
            fields.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field field : fields) {
            map.put(field.getName(), field);
        }
        return map;
    }

    public static String getErrStr(String template, String ... val) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)template) && val != null && val.length > 0) {
            int index = template.indexOf("{}");
            int i = 0;
            while (index >= 0) {
                template = template.replaceFirst("\\{\\}", val[i]);
                if (++i == val.length) break;
                index = template.indexOf("{}");
            }
        }
        return template;
    }
}

