/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.excel;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.CellType;

public class ExcelExportUtils<T> {
    public static <T> void getExportSheetData(HSSFWorkbook hwb, String sheetName, String[] needExportSheetAttrs, Integer startRow, List<T> datas) throws Exception {
        HSSFSheet sheet = hwb.getSheet(sheetName);
        for (int j = 0; j < datas.size(); ++j) {
            T t = datas.get(j);
            HSSFRow row = sheet.createRow(j + startRow);
            for (int k = 0; k < needExportSheetAttrs.length; ++k) {
                String fieldName = needExportSheetAttrs[k];
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method getMethod = t.getClass().getMethod(getMethodName, new Class[0]);
                Object value = getMethod.invoke(t, new Object[0]);
                if (value == null) continue;
                row.createCell(k, CellType.STRING).setCellValue(value.toString());
            }
        }
    }

    public static <T> void getExportSheetDataExpend(HSSFWorkbook hwb, String sheetName, String[] needExportSheetAttrs, Integer startRow, List<T> datas, List<List<String>> extendDatas) throws Exception {
        HSSFSheet sheet = hwb.getSheet(sheetName);
        for (int j = 0; j < datas.size(); ++j) {
            T t = datas.get(j);
            HSSFRow row = sheet.createRow(j + startRow);
            for (int k = 0; k < needExportSheetAttrs.length; ++k) {
                String fieldName = needExportSheetAttrs[k];
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                Method getMethod = t.getClass().getMethod(getMethodName, new Class[0]);
                Object value = getMethod.invoke(t, new Object[0]);
                if (value == null) continue;
                row.createCell(k, CellType.STRING).setCellValue(value.toString());
            }
            List<String> rowExtendDatas = extendDatas.get(j);
            if (rowExtendDatas == null || rowExtendDatas.size() <= 0) continue;
            for (int m = needExportSheetAttrs.length; m < needExportSheetAttrs.length + rowExtendDatas.size(); ++m) {
                row.createCell(m, CellType.STRING).setCellValue(rowExtendDatas.get(m - needExportSheetAttrs.length));
            }
        }
    }

    public static <T> void exportExcelDatasBySheetNames(String filePath, Map<String, String[]> needExportSheetAttrMap, Map<String, List<T>> datasMap, OutputStream out) throws Exception {
        int i;
        ArrayList<String> noNeedSheetNames = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        for (i = 0; i < hwb.getNumberOfSheets(); ++i) {
            noNeedSheetNames.add(hwb.getSheetAt(i).getSheetName());
        }
        if (needExportSheetAttrMap.keySet() != null && needExportSheetAttrMap.keySet().size() > 0) {
            for (String name : needExportSheetAttrMap.keySet()) {
                noNeedSheetNames.remove(name);
            }
        }
        if (noNeedSheetNames != null && noNeedSheetNames.size() > 0) {
            for (String name : noNeedSheetNames) {
                hwb.removeSheetAt(hwb.getSheetIndex(name));
            }
        }
        for (i = 0; i < hwb.getNumberOfSheets(); ++i) {
            String sheetName = hwb.getSheetAt(i).getSheetName();
            HSSFSheet sheet = hwb.getSheet(sheetName);
            if (sheet == null) continue;
            String[] needExportSheetAttr = needExportSheetAttrMap.get(sheetName);
            if (needExportSheetAttr == null || needExportSheetAttr.length < 2 || !StringUtils.isNumber(needExportSheetAttr[0].trim())) break;
            List<T> datas = datasMap.get(sheetName);
            if (datas == null || datas.size() == 0) continue;
            Integer startRow = Integer.valueOf(needExportSheetAttr[0].trim());
            Integer validCol = needExportSheetAttr.length - 1;
            if (startRow == null || startRow == 0 || validCol == null || validCol == 0) continue;
            for (int j = 0; j < datas.size(); ++j) {
                T t = datas.get(j);
                HSSFRow row = sheet.createRow(j + startRow);
                for (int k = 0; k < validCol; ++k) {
                    Field field = t.getClass().getDeclaredField(needExportSheetAttr[k + 1]);
                    String fieldName = field.getName();
                    String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                    Method getMethod = t.getClass().getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    row.createCell(k, CellType.STRING).setCellValue(value.toString());
                }
            }
        }
        hwb.write(out);
        hwb.close();
    }

    public static HSSFWorkbook getNeedExcelSheet(String filePath, List<String> sheetNames) throws Exception {
        ArrayList<String> noNeedSheetNames = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(CommonUtil.getFile(filePath));
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            noNeedSheetNames.add(hwb.getSheetAt(i).getSheetName());
        }
        if (sheetNames != null && sheetNames.size() > 0) {
            for (String name : sheetNames) {
                noNeedSheetNames.remove(name);
            }
        }
        if (noNeedSheetNames != null && noNeedSheetNames.size() > 0) {
            for (String name : noNeedSheetNames) {
                hwb.removeSheetAt(hwb.getSheetIndex(name));
            }
        }
        return hwb;
    }

    public static HSSFWorkbook getNeedExcelSheet(InputStream filePath, List<String> sheetNames) throws Exception {
        ArrayList<String> noNeedSheetNames = new ArrayList<String>();
        HSSFWorkbook hwb = new HSSFWorkbook(filePath);
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            noNeedSheetNames.add(hwb.getSheetAt(i).getSheetName());
        }
        if (sheetNames != null && sheetNames.size() > 0) {
            for (String name : sheetNames) {
                noNeedSheetNames.remove(name);
            }
        }
        if (noNeedSheetNames != null && noNeedSheetNames.size() > 0) {
            for (String name : noNeedSheetNames) {
                hwb.removeSheetAt(hwb.getSheetIndex(name));
            }
        }
        return hwb;
    }
}

