/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.date;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.smarthse.common.util.passwordLog.HttpUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class TimeUtil {
    private static final Logger log = LoggerFactory.getLogger(TimeUtil.class);
    private static final String HOLIDAY_API = "https://timor.tech/api/holiday/year/";
    private static final Map<Integer, Map<Boolean, ConcurrentHashSet<LocalDate>>> YEAR_HOLIDAY_MAP_SET = new HashMap<Integer, Map<Boolean, ConcurrentHashSet<LocalDate>>>();

    @PostConstruct
    private void init() {
        HashSet<Integer> yearSet = new HashSet<Integer>();
        yearSet.add(LocalDate.now().getYear());
        TimeUtil.startMaintenanceYearHolidayConcurrentHashSet(yearSet);
    }

    public static void main(String[] args) {
        String timeString1 = "2023-09-29 09:01:02.123";
        String timeString2 = "2023-10-08 11:04:06.128";
        log.info("\u65f6\u95f4\u5dee\uff1a" + TimeUtil.diffFormat(timeString1, timeString2, ChronoUnit.MILLIS));
    }

    private static String diffFormat(String st, String et) {
        return TimeUtil.diffFormat(st, et, ChronoUnit.SECONDS);
    }

    private static String diffFormat(String st, String et, ChronoUnit unit) {
        long differenceUnits = TimeUtil.calculateTimeDifference(st, et, unit);
        return TimeUtil.formatTimeDifferenceUnit(differenceUnits, unit);
    }

    private static Long calculateTimeDifference(String ss, String es) {
        return TimeUtil.calculateTimeDifference(ss, es, ChronoUnit.SECONDS);
    }

    private static long calculateTimeDifference(String ss, String es, ChronoUnit unit) {
        LocalDateTime sdt = TimeUtil.parseStringToDateTime(ss);
        LocalDateTime edt = TimeUtil.parseStringToDateTime(es);
        LocalDate sd = sdt.toLocalDate();
        LocalDate ed = edt.toLocalDate();
        HashSet<Integer> yearSet = new HashSet<Integer>();
        yearSet.add(sd.getYear());
        yearSet.add(ed.getYear());
        if (CollectionUtils.isEmpty(YEAR_HOLIDAY_MAP_SET)) {
            TimeUtil.startMaintenanceYearHolidayConcurrentHashSet(yearSet);
        }
        boolean startFreeDay = TimeUtil.isThisFreeDay(sd);
        boolean endFreeDay = TimeUtil.isThisFreeDay(ed);
        if (Objects.equals(sd, ed)) {
            return startFreeDay ? 0L : unit.between(sdt, edt);
        }
        int moveDays = 0;
        LocalDate calcSd = sd;
        LocalDate calcEd = ed;
        while (startFreeDay) {
            ++moveDays;
            calcSd = calcSd.minusDays(1L);
            startFreeDay = TimeUtil.isThisFreeDay(calcSd);
        }
        while (endFreeDay) {
            calcEd = calcEd.plusDays(1L);
            endFreeDay = TimeUtil.isThisFreeDay(calcEd);
        }
        moveDays = moveDays > 0 ? 1 : 0;
        LocalDateTime calcSdt = sdt;
        LocalDateTime salcEdt = edt;
        if (!sd.isEqual(calcSd)) {
            calcSdt = calcSd.atStartOfDay();
        }
        if (!ed.isEqual(calcEd)) {
            salcEdt = calcEd.atStartOfDay();
        }
        long differenceUnits = unit.between(calcSdt, salcEdt);
        long weekendHolidayDays = TimeUtil.calculateWeekendHolidayDays(calcSdt.toLocalDate(), salcEdt.toLocalDate());
        long subDays = weekendHolidayDays + (long)moveDays;
        differenceUnits = ChronoUnit.DAYS == unit ? (differenceUnits -= subDays) : (differenceUnits -= subDays * (unit.between(LocalTime.of(0, 0, 0), LocalTime.of(23, 59, 59, 999999999)) + 1L));
        return differenceUnits;
    }

    private static boolean isThisFreeDay(LocalDate date) {
        int year = date.getYear();
        if (CollectionUtils.isEmpty(YEAR_HOLIDAY_MAP_SET) || CollectionUtils.isEmpty(YEAR_HOLIDAY_MAP_SET.get(year))) {
            YEAR_HOLIDAY_MAP_SET.put(year, TimeUtil.obtainHolidayConcurrentHashSet(year));
        }
        Map<Boolean, ConcurrentHashSet<LocalDate>> holidayMapSet = YEAR_HOLIDAY_MAP_SET.get(year);
        Set holidaySet = (Set)holidayMapSet.get(true);
        Set nonHolidaySet = (Set)holidayMapSet.get(false);
        DayOfWeek ofWeek = date.getDayOfWeek();
        return !nonHolidaySet.contains(date) && (ofWeek == DayOfWeek.SATURDAY || ofWeek == DayOfWeek.SUNDAY || holidaySet.contains(date));
    }

    private static void startMaintenanceYearHolidayConcurrentHashSet(Set<Integer> yearSet) {
        Map<Integer, Map> yearHolidayMap = yearSet.stream().collect(Collectors.toMap(year -> year, TimeUtil::obtainHolidayConcurrentHashSet, (a, b) -> b));
        if (CollectionUtils.isEmpty(YEAR_HOLIDAY_MAP_SET)) {
            YEAR_HOLIDAY_MAP_SET.putAll(yearHolidayMap);
        } else {
            Map<Integer, Map> freshYearMember = yearHolidayMap.entrySet().stream().filter(e -> !YEAR_HOLIDAY_MAP_SET.containsKey(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            YEAR_HOLIDAY_MAP_SET.putAll(freshYearMember);
        }
    }

    private static Map<Boolean, ConcurrentHashSet<LocalDate>> obtainHolidayConcurrentHashSet(Integer year) {
        Gson gson = new Gson();
        Type type = new TypeToken<HolidayTemplate>(){}.getType();
        String json = HttpUtil.getInstance().sendHttpGet(HOLIDAY_API + year);
        HolidayTemplate template = (HolidayTemplate)gson.fromJson(json, type);
        Map<String, HolidayTemplate.Content> holidayMap = template.getHoliday();
        Map originalMap = holidayMap.values().stream().collect(Collectors.groupingBy(HolidayTemplate.Content::getHoliday, Collectors.mapping(v -> TimeUtil.parseStringToDateTime(v.getDate() + " 00:00:00.000").toLocalDate(), Collectors.toSet())));
        return originalMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ConcurrentHashSet((Iterable)entry.getValue()), (set1, set2) -> {
            set1.addAll((Collection)set2);
            return set1;
        }, ConcurrentHashMap::new));
    }

    private static long calculateWeekendHolidayDays(LocalDate sd, LocalDate ed) {
        long weekendHolidayDays = 0L;
        while (!sd.isAfter(ed)) {
            if (TimeUtil.isThisFreeDay(sd)) {
                ++weekendHolidayDays;
            }
            sd = sd.plusDays(1L);
        }
        return weekendHolidayDays;
    }

    public static LocalDateTime parseStringToDateTime(String timeString) {
        String[] supportedFormats = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss", "yyyyMMdd HHmmss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss.SSS", "yyyyMMdd HHmmssSSS"};
        LocalDateTime dateTime = null;
        for (String format : supportedFormats) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                dateTime = LocalDateTime.parse(timeString, formatter);
                break;
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        if (dateTime == null) {
            throw new RuntimeException("\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff01");
        }
        return dateTime;
    }

    private static String formatTimeDifferenceUnit(long timeInUnits, ChronoUnit unit) {
        Duration duration = Duration.of(timeInUnits, unit);
        long millis = duration.toMillis();
        return TimeUtil.formatTimeDifferenceMills(millis, unit);
    }

    private static String formatTimeDifferenceMills(long mills, ChronoUnit unit) {
        int ss = 1000;
        int mi = ss * 60;
        int hh = mi * 60;
        int dd = hh * 24;
        long day = mills / (long)dd;
        long hou = mills % (long)dd / (long)hh;
        long min = mills % (long)hh / (long)mi;
        long sec = mills % (long)mi / (long)ss;
        long mil = mills % (long)ss;
        return TimeUtil.formatDurationSplice(day, hou, min, sec, mil, unit);
    }

    private static String formatDurationSplice(long days, long hours, long minutes, long seconds, long mills) {
        if (days == 0L && hours == 0L && minutes == 0L && seconds == 0L && mills == 0L) {
            return "0\u6beb\u79d2";
        }
        Long[] array = new Long[]{days, hours, minutes, seconds, mills};
        for (int start = 0; start < array.length && array[start] == 0L; ++start) {
            array[start] = null;
        }
        for (int end = array.length - 1; end >= 0 && array[end] == 0L; --end) {
            array[end] = null;
        }
        StringBuilder builder = new StringBuilder();
        Long day = array[0];
        Long hou = array[1];
        Long min = array[2];
        Long sec = array[3];
        Long mil = array[4];
        if (day != null) {
            builder.append(day).append("\u5929");
        }
        if (hou != null) {
            builder.append(hou).append("\u65f6");
        }
        if (min != null) {
            builder.append(min).append("\u5206");
        }
        if (sec != null) {
            builder.append(sec).append("\u79d2");
        }
        if (mil != null) {
            builder.append(mil).append("\u6beb\u79d2");
        }
        return builder.toString();
    }

    private static String formatDurationSplice(long days, long hours, long minutes, long seconds, long mills, ChronoUnit unit) {
        if (days == 0L && hours == 0L && minutes == 0L && seconds == 0L && mills == 0L) {
            switch (unit) {
                case DAYS: {
                    return "0\u5929";
                }
                case HOURS: {
                    return "0\u65f6";
                }
                case MINUTES: {
                    return "0\u5206";
                }
                case SECONDS: {
                    return "0\u79d2";
                }
                case MILLIS: {
                    return "0\u6beb\u79d2";
                }
            }
            return "0\u79d2";
        }
        Long[] array = new Long[]{days, hours, minutes, seconds, mills};
        for (int start = 0; start < array.length && array[start] == 0L; ++start) {
            array[start] = null;
        }
        for (int end = array.length - 1; end >= 0 && array[end] == 0L; --end) {
            array[end] = null;
        }
        StringBuilder builder = new StringBuilder();
        Long day = array[0];
        Long hou = array[1];
        Long min = array[2];
        Long sec = array[3];
        Long mil = array[4];
        if (day != null) {
            builder.append(day).append("\u5929");
        }
        if (hou != null) {
            builder.append(hou).append("\u65f6");
        }
        if (min != null) {
            builder.append(min).append("\u5206");
        }
        if (sec != null) {
            builder.append(sec).append("\u79d2");
        }
        if (mil != null) {
            builder.append(mil).append("\u6beb\u79d2");
        }
        return builder.toString();
    }

    static class HolidayTemplate
    implements Serializable {
        private static final long serialVersionUID = 7004590945038461126L;
        private Integer code;
        private Map<String, Content> holiday;

        public Integer getCode() {
            return this.code;
        }

        public Map<String, Content> getHoliday() {
            return this.holiday;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setHoliday(Map<String, Content> holiday) {
            this.holiday = holiday;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HolidayTemplate)) {
                return false;
            }
            HolidayTemplate other = (HolidayTemplate)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Map<String, Content> this$holiday = this.getHoliday();
            Map<String, Content> other$holiday = other.getHoliday();
            return !(this$holiday == null ? other$holiday != null : !((Object)this$holiday).equals(other$holiday));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HolidayTemplate;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Map<String, Content> $holiday = this.getHoliday();
            result = result * 59 + ($holiday == null ? 43 : ((Object)$holiday).hashCode());
            return result;
        }

        public String toString() {
            return "TimeUtil.HolidayTemplate(code=" + this.getCode() + ", holiday=" + this.getHoliday() + ")";
        }

        static class Content
        implements Serializable {
            private static final long serialVersionUID = 5689990994927562337L;
            private Boolean holiday;
            private String name;
            private Integer wage;
            private String date;
            private Integer rest;

            public Boolean getHoliday() {
                return this.holiday;
            }

            public String getName() {
                return this.name;
            }

            public Integer getWage() {
                return this.wage;
            }

            public String getDate() {
                return this.date;
            }

            public Integer getRest() {
                return this.rest;
            }

            public void setHoliday(Boolean holiday) {
                this.holiday = holiday;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setWage(Integer wage) {
                this.wage = wage;
            }

            public void setDate(String date) {
                this.date = date;
            }

            public void setRest(Integer rest) {
                this.rest = rest;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Content)) {
                    return false;
                }
                Content other = (Content)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$holiday = this.getHoliday();
                Boolean other$holiday = other.getHoliday();
                if (this$holiday == null ? other$holiday != null : !((Object)this$holiday).equals(other$holiday)) {
                    return false;
                }
                Integer this$wage = this.getWage();
                Integer other$wage = other.getWage();
                if (this$wage == null ? other$wage != null : !((Object)this$wage).equals(other$wage)) {
                    return false;
                }
                Integer this$rest = this.getRest();
                Integer other$rest = other.getRest();
                if (this$rest == null ? other$rest != null : !((Object)this$rest).equals(other$rest)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$date = this.getDate();
                String other$date = other.getDate();
                return !(this$date == null ? other$date != null : !this$date.equals(other$date));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Content;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $holiday = this.getHoliday();
                result = result * 59 + ($holiday == null ? 43 : ((Object)$holiday).hashCode());
                Integer $wage = this.getWage();
                result = result * 59 + ($wage == null ? 43 : ((Object)$wage).hashCode());
                Integer $rest = this.getRest();
                result = result * 59 + ($rest == null ? 43 : ((Object)$rest).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $date = this.getDate();
                result = result * 59 + ($date == null ? 43 : $date.hashCode());
                return result;
            }

            public String toString() {
                return "TimeUtil.HolidayTemplate.Content(holiday=" + this.getHoliday() + ", name=" + this.getName() + ", wage=" + this.getWage() + ", date=" + this.getDate() + ", rest=" + this.getRest() + ")";
            }
        }
    }
}

