/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.date;

import cn.smarthse.common.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class DateUtil {
    public static Date parseDate(String dateString, String pattern) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        Date date = dateFormat.parse(dateString);
        return date;
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String getNowDate(String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }

    public static String getNowDateString() {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.now();
        return dateTimeFormatter.format(localDateTime);
    }

    public static LocalDateTime parseDateTime(String dateTime, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return LocalDateTime.parse(dateTime, dateTimeFormatter);
    }

    public static int getYear() {
        return LocalDate.now().getYear();
    }

    public static int getMonth() {
        Month month = LocalDate.now().getMonth();
        return month.getValue();
    }

    public static int getDay() {
        return LocalDate.now().getDayOfMonth();
    }

    public static Date getDate(String dateStr, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getWeekOfDate(LocalDate localDate) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        DayOfWeek dayOfWeek = localDate.getDayOfWeek();
        int w = dayOfWeek.getValue();
        if (w < 0 || w >= 7) {
            w = 0;
        }
        return weekDays[w];
    }

    public static int getDayOfWeek(LocalDate localDate) {
        return localDate.getDayOfWeek().getValue();
    }

    public static boolean isLeapYear(int year) {
        Year y = Year.of(year);
        return y.isLeap();
    }

    public static LocalDate getDate(int year, int month, int days) {
        Year y = Year.of(year);
        YearMonth yearMonth = y.atMonth(month);
        LocalDate localDate = yearMonth.atDay(days);
        return localDate;
    }

    public static LocalDate getDateAutoParse(int year, int month, int days) {
        MonthDay monthDay = MonthDay.of(month, days);
        return monthDay.atYear(year);
    }

    public static String getDateString(int year, int month, int day) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        MonthDay monthDay = MonthDay.of(month, day);
        LocalDate date = monthDay.atYear(year);
        return dateTimeFormatter.format(date);
    }

    public static String getDateTimeString(LocalDate localDate) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return dateTimeFormatter.format(localDate);
    }

    public static String getNextDate(LocalDateTime localDate, int i, String pattern) {
        LocalDateTime nextDate = localDate.plusDays(i);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(nextDate);
    }

    public static String getLastDate(LocalDateTime localDate, int i, String pattern) {
        LocalDateTime nextDate = localDate.minusDays(i);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(nextDate);
    }

    public static LocalDate getNextDate(LocalDate localDate, int i) {
        LocalDate nextDate = localDate.plusDays(i);
        return nextDate;
    }

    public static Date getNextDate(Date date, int i) {
        LocalDate localDate = DateUtil.getLocalDate(DateUtil.format(date, "yyyy-MM-dd"));
        LocalDate nextDate = localDate.plusDays(i);
        return Date.from(nextDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String getNOwTime() {
        String dateTime = DateUtil.getNowDateString();
        return dateTime.substring(11);
    }

    public static long caculateHours(LocalDateTime time1, LocalDateTime time2) {
        return ChronoUnit.HOURS.between(time1, time2);
    }

    public static LocalDate getStartDateOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 2);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return DateUtil.getFromDate(date).toLocalDate();
    }

    public static LocalDate getEndDateOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(7, 7);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        Date date = cal.getTime();
        return DateUtil.getFromDate(date).toLocalDate().plusDays(1L);
    }

    public static LocalDate getStartDateOfMonth() {
        LocalDate now = LocalDate.now();
        return DateUtil.getLocalDateTime(now.getYear(), now.getMonthValue(), 1, 0, 0, 0).toLocalDate();
    }

    public static LocalDate getEndDateOfMonth() {
        LocalDate now = LocalDate.now();
        return DateUtil.getLocalDateTime(now.getYear(), now.getMonthValue(), now.getMonth().maxLength(), 0, 0, 0).toLocalDate();
    }

    public String getDateToDay(String pattern) {
        LocalDate today = LocalDate.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(today);
    }

    public static long caculateDays(LocalDate date1, LocalDate date2) {
        return ChronoUnit.DAYS.between(date1, date2);
    }

    public static long caculateYears(LocalDate date1, LocalDate date2) {
        return ChronoUnit.YEARS.between(date1, date2);
    }

    public static long caculateMonths(LocalDate date1, LocalDate date2) {
        return ChronoUnit.MONTHS.between(date1, date2);
    }

    public static long caculateMinutes(LocalDateTime time1, LocalDateTime time2) {
        return ChronoUnit.MINUTES.between(time1, time2);
    }

    public static long caculateSeconds(LocalDateTime time1, LocalDateTime time2) {
        return ChronoUnit.SECONDS.between(time1, time2);
    }

    public static long getMill(LocalDateTime localDateTime) {
        return localDateTime.toInstant(ZoneOffset.of("+8")).toEpochMilli();
    }

    public static LocalDateTime getFromDate(Date date) {
        if (date != null) {
            Instant instant = date.toInstant();
            ZoneId zoneId = ZoneId.systemDefault();
            return LocalDateTime.ofInstant(instant, zoneId);
        }
        return null;
    }

    public static LocalDate getFromDate2(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        return instant.atZone(zoneId).toLocalDate();
    }

    public static String formatDate(LocalDateTime time) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return dateTimeFormatter.format(time);
    }

    public static String formatDate(LocalDateTime time, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(time);
    }

    public static String formatDate(LocalDate date, String pattern) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        return dateTimeFormatter.format(date);
    }

    public static Date getDateNow() {
        ZoneId zoneId = ZoneId.of("GMT+08");
        LocalDateTime localDateTime = LocalDateTime.now();
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static Date getDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        ZoneId zoneId = ZoneId.of("GMT+08");
        ZonedDateTime zdt = localDateTime.atZone(zoneId);
        Date date = Date.from(zdt.toInstant());
        return date;
    }

    public static LocalDateTime getLocalDateTime(int year, int month, int day, int hour, int min, int second) {
        LocalDateTime of = LocalDateTime.of(year, month, day, hour, min, second);
        return of;
    }

    public static LocalDate getLocalDate(String date) {
        return LocalDate.parse(date);
    }

    public static int getHour() {
        return LocalDateTime.now().getHour();
    }

    public static String getDateTimeStringByMil(long millisecond) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getDateStringByMil(long millisecond) {
        Date date = new Date(millisecond);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static long getMillisecond() {
        return new Date().getTime();
    }

    public static long getMillisecondByDateTimeString(String dateTime, String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(dateTime).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static DayCompare dayComparePrecise(LocalDate fromDate, LocalDate toDate) {
        int day;
        boolean isChange = false;
        if (toDate.compareTo(fromDate) < 0) {
            LocalDate temp = fromDate;
            fromDate = toDate;
            toDate = temp;
            isChange = true;
        }
        int fromYear = fromDate.getYear();
        int fromMonth = fromDate.getMonthValue();
        int fromDay = fromDate.getDayOfMonth();
        int toYear = toDate.getYear();
        int toMonth = toDate.getMonthValue();
        int toDay = toDate.getDayOfMonth();
        int year = toYear - fromYear;
        int month = toMonth - fromMonth;
        if (month < 0) {
            --year;
            month = 12 - fromMonth + toMonth;
        }
        if ((day = toDay - fromDay) < 0) {
            --month;
            int maxDay = DateUtil.getMaxDaysOfOneMonth(fromYear, fromMonth);
            day = maxDay - fromDay + toDay;
        }
        if (month < 0) {
            --year;
            month = 12 + month;
        }
        if (isChange) {
            year = 0 - year;
            month = 0 - month;
            day = 0 - day;
        }
        return new DayCompare(year, month, day);
    }

    private static int getMaxDaysOfOneMonth(int year, int month) {
        int day = 1;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day);
        return cal.getActualMaximum(5);
    }

    public static int getMonthDays(int year, int month) {
        if (month == 2) {
            if (DateUtil.isLeap(year)) {
                return 29;
            }
            return 28;
        }
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        return 31;
    }

    public static boolean isLeap(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    public static Date getDayStartDate(Date date) throws ParseException {
        if (date == null) {
            return null;
        }
        String format = DateUtil.format(date, "yyyy-MM-dd");
        return DateUtil.parseDate(format + " 00:00:00", "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getDayEndDate(Date date) throws ParseException {
        if (date == null) {
            return null;
        }
        String format = DateUtil.format(date, "yyyy-MM-dd");
        return DateUtil.parseDate(format + " 23:59:59", "yyyy-MM-dd HH:mm:ss");
    }

    public static Date getMaxDateByMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        cal.set(5, lastDay);
        return cal.getTime();
    }

    public static Date getMinDateByMonth(Integer year, Integer month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int firstDay = cal.getActualMinimum(5);
        cal.set(5, firstDay);
        return cal.getTime();
    }

    public static ImmutablePair<Integer, Integer> getWeekNumber(LocalDate specifiedDate) {
        int thisYear = specifiedDate.get(WeekFields.ISO.weekBasedYear());
        int thisWeekNumber = specifiedDate.get(WeekFields.ISO.weekOfWeekBasedYear());
        String yearStr = StringUtils.leftPad((String)String.valueOf(thisWeekNumber), (int)2, (char)'0');
        LocalDate lastWeekStart = specifiedDate.minus(1L, ChronoUnit.WEEKS);
        int preYear = lastWeekStart.get(WeekFields.ISO.weekBasedYear());
        int lastWeekNumber = lastWeekStart.get(WeekFields.ISO.weekOfWeekBasedYear());
        String preYearStr = StringUtils.leftPad((String)String.valueOf(lastWeekNumber), (int)2, (char)'0');
        Integer thisWeek = Integer.valueOf(thisYear + yearStr);
        Integer preWeek = Integer.valueOf(preYear + preYearStr);
        ImmutablePair pair = new ImmutablePair((Object)preWeek, (Object)thisWeek);
        return pair;
    }

    public static List<String> findWholeYearsBetween(Date startDate, Date endDate) {
        try {
            ArrayList<String> years = new ArrayList<String>();
            LocalDate start = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            LocalDate end = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            int startDateYear = start.getYear();
            int endDateYear = end.getYear();
            if (startDateYear >= endDateYear) {
                return Collections.emptyList();
            }
            while (start.isBefore(end)) {
                years.add(String.valueOf(start.getYear()));
                start = start.plusYears(1L);
            }
            if (start.getMonthValue() != 1 || start.getDayOfMonth() != 1) {
                years.remove(String.valueOf(startDateYear));
            }
            if (end.getMonthValue() != 12 || end.getDayOfMonth() != 31) {
                years.remove(String.valueOf(endDateYear));
            }
            return years;
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public static void main(String[] args) {
        Date date1 = DateUtil.getDate("2019-03-01", "yyyy-MM-dd");
        Date date2 = DateUtil.getDate("2023-05-01", "yyyy-MM-dd");
        System.out.println(DateUtil.findWholeYearsBetween(date1, date2));
    }

    public static class DayCompare {
        private int year;
        private int month;
        private int day;

        public DayCompare(int year, int month, int day) {
            this.year = year;
            this.month = month;
            this.day = day;
        }

        public int getYear() {
            return this.year;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public int getMonth() {
            return this.month;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public int getDay() {
            return this.day;
        }

        public void setDay(int day) {
            this.day = day;
        }
    }
}

