/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util.compare;

import cn.smarthse.common.util.compare.Compare;
import cn.smarthse.common.util.compare.CompareNode;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class CompareUtils<T> {
    private static final String COMMA = "\uff0c";

    public String compare(T source, T target) {
        return this.compare(source, target, null);
    }

    public String compare(T source, T target, List<String> ignoreCompareFields) {
        if (Objects.isNull(source) && Objects.isNull(target)) {
            return "";
        }
        Map<String, CompareNode> sourceMap = this.getFiledValueMap(source);
        Map<String, CompareNode> targetMap = this.getFiledValueMap(target);
        if (sourceMap.isEmpty() && targetMap.isEmpty()) {
            return "";
        }
        if (sourceMap.isEmpty()) {
            return this.doEmpty(targetMap, ignoreCompareFields);
        }
        String s = this.doCompare(sourceMap, targetMap, ignoreCompareFields);
        if (!s.endsWith(COMMA)) {
            return s;
        }
        return s.substring(0, s.length() - 1);
    }

    public String compareSpecific(T source, T target, List<String> specificCompareFields) {
        if (Objects.isNull(source) && Objects.isNull(target)) {
            return "";
        }
        Map<String, CompareNode> sourceMap = this.getFiledValueMap(source);
        Map<String, CompareNode> targetMap = this.getFiledValueMap(target);
        if (sourceMap.isEmpty() && targetMap.isEmpty()) {
            return "";
        }
        if (sourceMap.isEmpty()) {
            return this.doEmptySpecific(targetMap, specificCompareFields);
        }
        String s = this.doCompareSpecific(sourceMap, targetMap, specificCompareFields);
        if (!s.endsWith(COMMA)) {
            return s;
        }
        return s.substring(0, s.length() - 1);
    }

    private String doEmpty(Map<String, CompareNode> targetMap, List<String> ignoreCompareFields) {
        StringBuilder sb = new StringBuilder();
        Collection<CompareNode> values = targetMap.values();
        int size = values.size();
        int current = 0;
        for (CompareNode node : values) {
            ++current;
            Object o = Optional.ofNullable(node.getFieldValue()).orElse("");
            if (Objects.nonNull(ignoreCompareFields) && ignoreCompareFields.contains(node.getFieldKey()) || o.toString().length() <= 0) continue;
            sb.append("[" + node.getFieldName() + "\uff1a" + o + "]");
            if (current >= size) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private String doEmptySpecific(Map<String, CompareNode> targetMap, List<String> specificCompareFields) {
        StringBuilder sb = new StringBuilder();
        Collection<CompareNode> values = targetMap.values();
        int size = values.size();
        int current = 0;
        for (CompareNode node : values) {
            ++current;
            Object o = Optional.ofNullable(node.getFieldValue()).orElse("");
            if (CollectionUtils.isEmpty(specificCompareFields) || !specificCompareFields.contains(node.getFieldKey()) || o.toString().length() <= 0) continue;
            sb.append("[" + node.getFieldName() + "\uff1a" + o + "]");
            if (current >= size) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private String doCompare(Map<String, CompareNode> sourceMap, Map<String, CompareNode> targetMap, List<String> ignoreCompareFields) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = sourceMap.keySet();
        int size = keys.size();
        int current = 0;
        for (String key : keys) {
            String tv;
            String sv;
            ++current;
            CompareNode sn = sourceMap.get(key);
            CompareNode tn = targetMap.get(key);
            if (Objects.nonNull(ignoreCompareFields) && ignoreCompareFields.contains(sn.getFieldKey()) || (sv = Optional.ofNullable(sn.getFieldValue()).orElse("").toString()).equals(tv = Optional.ofNullable(tn.getFieldValue()).orElse("").toString())) continue;
            sb.append(String.format("[%s\uff1a%s -> %s]", sn.getFieldName(), sv, tv));
            if (current >= size) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private String doCompareSpecific(Map<String, CompareNode> sourceMap, Map<String, CompareNode> targetMap, List<String> SpeciCompareFields) {
        StringBuilder sb = new StringBuilder();
        Set<String> keys = sourceMap.keySet();
        int size = keys.size();
        int current = 0;
        for (String key : keys) {
            String tv;
            String sv;
            ++current;
            CompareNode sn = sourceMap.get(key);
            CompareNode tn = targetMap.get(key);
            if (CollectionUtils.isEmpty(SpeciCompareFields) || !SpeciCompareFields.contains(sn.getFieldKey()) || (sv = Optional.ofNullable(sn.getFieldValue()).orElse("").toString()).equals(tv = Optional.ofNullable(tn.getFieldValue()).orElse("").toString())) continue;
            sb.append(String.format("[%s\uff1a%s -> %s]", sn.getFieldName(), sv, tv));
            if (current >= size) continue;
            sb.append(COMMA);
        }
        return sb.toString();
    }

    private Map<String, CompareNode> getFiledValueMap(T t) {
        if (Objects.isNull(t)) {
            return Collections.emptyMap();
        }
        Field[] fields = t.getClass().getDeclaredFields();
        if (Objects.isNull(fields) || fields.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, CompareNode> map = new LinkedHashMap<String, CompareNode>();
        for (Field field : fields) {
            Compare compareAnnotation = field.getAnnotation(Compare.class);
            field.setAccessible(true);
            try {
                String fieldKey = field.getName();
                CompareNode node = new CompareNode();
                node.setFieldKey(fieldKey);
                node.setFieldValue(field.get(t));
                if (compareAnnotation != null) {
                    node.setFieldName(compareAnnotation.value());
                } else {
                    node.setFieldName(fieldKey);
                }
                map.put(fieldKey, node);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        return map;
    }
}

