/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.smarthse.common.util.CommonUtil;
import cn.smarthse.common.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class ZipCompressorUtil {
    private File zipFile;

    public ZipCompressorUtil(String finalFile) {
        this.zipFile = CommonUtil.getFile(finalFile);
    }

    public void compressExe(String srcPathName) {
        File srcdir = CommonUtil.getFile(srcPathName);
        if (!srcdir.exists()) {
            throw new RuntimeException(srcPathName + "\u4e0d\u5b58\u5728\uff01");
        }
        Project prj = new Project();
        Zip zip = new Zip();
        zip.setProject(prj);
        zip.setDestFile(this.zipFile);
        FileSet fileSet = new FileSet();
        fileSet.setProject(prj);
        fileSet.setDir(srcdir);
        zip.addFileset(fileSet);
        zip.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getDownZipFile(List<File> files, String baseName, OutputStream outputStream) {
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        try {
            for (File f : files) {
                zos.putNextEntry(new ZipEntry(baseName + f.getName()));
                FileInputStream fis = new FileInputStream(f);
                byte[] buffer = new byte[1024];
                int r = 0;
                while ((r = fis.read(buffer)) != -1) {
                    zos.write(buffer, 0, r);
                }
                fis.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                zos.flush();
                zos.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getDownZipFile(Map<String, List<File>> filesMap, OutputStream outputStream) {
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        try {
            if (filesMap != null) {
                for (String dirName : filesMap.keySet()) {
                    if (!StringUtils.isNotEmpty(dirName) || filesMap.get(dirName) == null || filesMap.get(dirName).size() <= 0) continue;
                    List<File> files = filesMap.get(dirName);
                    for (File f : files) {
                        zos.putNextEntry(new ZipEntry(("rootDir".equals(dirName) ? "" : dirName + File.separator) + f.getName()));
                        FileInputStream fis = new FileInputStream(f);
                        byte[] buffer = new byte[1024];
                        int r = 0;
                        while ((r = fis.read(buffer)) != -1) {
                            zos.write(buffer, 0, r);
                        }
                        fis.close();
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                zos.flush();
                zos.close();
            }
            catch (Exception exception) {}
        }
    }
}

