/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.smarthse.common.util.StringUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.filechooser.FileSystemView;

public class QrCodeUtil {
    private static final int CODE_WIDTH = 400;
    private static final int CODE_HEIGHT = 400;
    private static final int FRONT_COLOR = 0;
    private static final int BACKGROUND_COLOR = 0xFFFFFF;

    public static void createCodeToFile(String content2, File codeImgFileSaveDir, String fileName) {
        try {
            if (StringUtils.isBlank((CharSequence)content2) || StringUtils.isBlank((CharSequence)fileName)) {
                return;
            }
            content2 = content2.trim();
            if (codeImgFileSaveDir == null || codeImgFileSaveDir.isFile()) {
                codeImgFileSaveDir = FileSystemView.getFileSystemView().getHomeDirectory();
            }
            if (!codeImgFileSaveDir.exists()) {
                codeImgFileSaveDir.mkdirs();
            }
            BufferedImage bufferedImage = QrCodeUtil.getBufferedImage(content2);
            File codeImgFile = new File(codeImgFileSaveDir, fileName);
            ImageIO.write((RenderedImage)bufferedImage, "png", codeImgFile);
            System.out.println("\u4e8c\u7ef4\u7801\u56fe\u7247\u751f\u6210\u6210\u529f\uff1a" + codeImgFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createCodeToOutputStream(String content2, OutputStream outputStream) {
        try {
            if (StringUtils.isBlank((CharSequence)content2)) {
                return;
            }
            content2 = content2.trim();
            BufferedImage bufferedImage = QrCodeUtil.getBufferedImage(content2);
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
            System.out.println("\u4e8c\u7ef4\u7801\u56fe\u7247\u751f\u6210\u5230\u8f93\u51fa\u6d41\u6210\u529f...");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BufferedImage getBufferedImage(String content2) throws WriterException {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.M);
        hints.put(EncodeHintType.MARGIN, 1);
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        BitMatrix bitMatrix = multiFormatWriter.encode(content2, BarcodeFormat.QR_CODE, 400, 400, hints);
        BufferedImage bufferedImage = new BufferedImage(400, 400, 4);
        for (int x = 0; x < 400; ++x) {
            for (int y = 0; y < 400; ++y) {
                bufferedImage.setRGB(x, y, bitMatrix.get(x, y) ? 0 : 0xFFFFFF);
            }
        }
        return bufferedImage;
    }
}

