/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import com.github.pagehelper.PageInfo;
import java.util.ArrayList;
import java.util.List;

public class PageUtil {
    public static <T> List<T> filterPage(List<T> listAll, int pageNum, int pageSize) {
        ArrayList<T> list = new ArrayList<T>();
        if (pageNum <= 0 || pageSize <= 0) {
            return list;
        }
        for (int i = (pageNum - 1) * pageSize; i < pageNum * pageSize && i < listAll.size(); ++i) {
            list.add(listAll.get(i));
        }
        return list;
    }

    public static <T> PageInfo<T> getPageInfo(List<T> listAll, int pageNum, int pageSize) {
        int total = listAll.size();
        int lastPage = total / pageSize;
        if (total % pageSize != 0) {
            ++lastPage;
        }
        List<T> pageList = PageUtil.filterPage(listAll, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        pageInfo.setPageNum(pageNum);
        pageInfo.setPageSize(pageSize);
        pageInfo.setSize(pageList.size());
        pageInfo.setStartRow((long)(pageNum - 1) * (long)pageSize + 1L);
        pageInfo.setEndRow((long)(pageNum - 1) * (long)pageSize + (long)pageList.size());
        pageInfo.setPages(lastPage);
        pageInfo.setPrePage(pageNum - 1);
        pageInfo.setNextPage(pageNum + 1);
        pageInfo.setIsFirstPage(pageNum == 1);
        pageInfo.setIsLastPage(pageNum == lastPage);
        pageInfo.setHasPreviousPage(pageNum > 1);
        pageInfo.setHasNextPage(pageNum * pageSize < total);
        pageInfo.setNavigateFirstPage(1);
        pageInfo.setNavigateLastPage(lastPage);
        pageInfo.setTotal((long)total);
        pageInfo.setList(pageList);
        return pageInfo;
    }
}

