/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.smarthse.common.util.CommonUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;

public class KeyWordFilterUtil {
    private static Logger logger = LoggerFactory.getLogger(KeyWordFilterUtil.class);
    private static Pattern pattern = null;
    private static Properties props = null;

    public static void initPatternByProps() throws Exception {
        try {
            props = PropertiesLoaderUtils.loadAllProperties((String)"works.properties");
            KeyWordFilterUtil.initPatternByKeyText(props.stringPropertyNames());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initPattern(String filePath) throws Exception {
        String line;
        if (pattern != null) {
            pattern = null;
        }
        StringBuilder sb = new StringBuilder("");
        BufferedReader bf = new BufferedReader(new FileReader(CommonUtil.getFile(filePath)));
        sb.append("(");
        int flag = 0;
        while ((line = bf.readLine()) != null) {
            logger.info(flag + " - " + line);
            ++flag;
            sb.append(line + "|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        pattern = Pattern.compile(sb.toString());
        bf.close();
    }

    public static void initPatternByKeyText(Collection<String> keylist) throws Exception {
        StringBuilder sb = new StringBuilder("(");
        for (String key : props.stringPropertyNames()) {
            sb.append(key + "|");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        if (logger.isInfoEnabled()) {
            logger.info("\u8fc7\u6ee4\u8bcd:" + sb.toString());
        }
        pattern = Pattern.compile(sb.toString());
    }

    public static Collection<String> getList() {
        if (props != null) {
            return props.stringPropertyNames();
        }
        return new ArrayList<String>();
    }

    public static void addKey(String key) {
        if (logger.isInfoEnabled()) {
            logger.info("\u6dfb\u52a0\u5173\u952e\u8bcd:" + key);
        }
        props.put(key, "");
    }

    public static void deleteByKey(String key) {
        if (logger.isInfoEnabled()) {
            logger.info("\u5220\u9664\u5173\u952e\u8bcd:" + key);
        }
        props.remove(key);
    }

    public static String doFilter(String str) {
        Matcher matcher = pattern.matcher(str);
        str = matcher.replaceAll("*");
        return str;
    }
}

