/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.smarthse.common.util.CommonUtil;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;

public class Java2WordGenerator {
    @Autowired(required=false)
    private ServletContext servletContext;
    private Configuration configuration = new Configuration();
    private Map<String, Template> allTemplates = new HashMap<String, Template>();

    public File createDoc(Map<?, ?> dataMap, String templateName, String targetFile) {
        File f = CommonUtil.getFile(targetFile);
        try {
            f.getParentFile().mkdirs();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        Template t = this.allTemplates.get(templateName);
        if (t == null) {
            throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728!");
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");
            t.process(dataMap, (Writer)w);
            ((Writer)w).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return f;
    }

    public File generaDoc(Map<?, ?> dataMap, String templateName, String targetFile) {
        File f = new File(targetFile);
        try {
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        Template t = this.allTemplates.get(templateName);
        if (t == null) {
            throw new RuntimeException("\u6a21\u677f\u4e0d\u5b58\u5728!");
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8");
            t.process(dataMap, (Writer)w);
            ((Writer)w).close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return f;
    }

    public void setDefaultEncoding(String defaultEncoding) {
        this.configuration.setDefaultEncoding(defaultEncoding);
    }

    public void setBasePackagePath(String configLocation) throws IOException {
        if (this.servletContext != null) {
            this.configuration.setServletContextForTemplateLoading((Object)this.servletContext, configLocation);
        } else {
            this.configuration.setClassForTemplateLoading(Java2WordGenerator.class, configLocation);
        }
    }

    public void setTemplates(Properties templateProperties) {
        if (templateProperties != null) {
            Enumeration<?> en = templateProperties.propertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = templateProperties.getProperty(key);
                if (value == null) {
                    value = templateProperties.get(key);
                }
                try {
                    this.allTemplates.put(key, this.configuration.getTemplate(String.valueOf(value)));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

