/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.smarthse.common.util.CommonUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;
import sun.font.FontDesignMetrics;

public class ImgMarkUtil {
    public static final void pressImage(String pressImg, String srcImg, String targetImg, int posType, float alpha) {
        try {
            File _file = CommonUtil.getFile(srcImg);
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            File _filebiao = CommonUtil.getFile(pressImg);
            BufferedImage src_biao = ImageIO.read(_filebiao);
            int wideth_biao = ((Image)src_biao).getWidth(null);
            int height_biao = ((Image)src_biao).getHeight(null);
            Point p = ImgMarkUtil.getPoint(posType, wideth, height, wideth_biao, height_biao);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            g.drawImage(src_biao, (int)p.getX(), (int)p.getY(), wideth_biao, height_biao, null);
            g.dispose();
            FileOutputStream out = new FileOutputStream(CommonUtil.getFile(targetImg));
            ImageIO.write((RenderedImage)image, ".jpg", out);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void pressText(String pressText, String srcImg, String targetImg, String fontName, int fontStyle, Color color, int fontSize, int posType, float alpha) {
        try {
            File _file = CommonUtil.getFile(srcImg);
            BufferedImage src = ImageIO.read(_file);
            int wideth = ((Image)src).getWidth(null);
            int height = ((Image)src).getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height, 1);
            Graphics2D g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            g.setColor(color);
            Font wfont = new Font(fontName, fontStyle, fontSize);
            g.setFont(wfont);
            g.setComposite(AlphaComposite.getInstance(10, alpha));
            FontDesignMetrics fm = FontDesignMetrics.getMetrics(wfont);
            Point p = ImgMarkUtil.getPoint(posType, wideth, height, ((FontMetrics)fm).stringWidth(pressText), ((FontMetrics)fm).getHeight());
            ((Graphics)g).drawString(pressText, (int)p.getX(), (int)p.getY() + fontSize);
            g.dispose();
            FileOutputStream out = new FileOutputStream(CommonUtil.getFile(targetImg));
            ImageIO.write((RenderedImage)image, ".jpg", out);
            out.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static Point getPoint(int posType, int srcw, int srch, int imgw, int imgh) {
        Point p = new Point();
        if (posType == 1) {
            p.setLocation(5, 5);
        } else if (posType == 2) {
            p.setLocation(5, srch - imgh - 5);
        } else if (posType == 3) {
            p.setLocation(srcw - imgw - 5, 5);
        } else if (posType == 4) {
            p.setLocation(srcw - imgw - 5, srch - imgh - 5);
        } else {
            p.setLocation((srcw - imgw) / 2, (srch - imgh) / 2);
        }
        return p;
    }
}

