/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.smarthse.common.freemarker.OutPutDocStr;
import cn.smarthse.common.util.StringUtils;
import cn.smarthse.common.util.X509TrustUtiil;
import cn.smarthse.common.util.ZipUtils;
import cn.smarthse.common.util.leak.SSRFLeakUtil;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.pdf.PdfConverter;
import org.apache.poi.xwpf.converter.pdf.PdfOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class FileUtil {
    public static String downAndReadFile(String filePath, String downloadPath, String fileName) {
        String uname;
        File savePath = new File(downloadPath);
        if (!savePath.exists()) {
            savePath.mkdir();
        }
        if (StringUtils.isEmpty((CharSequence)(uname = fileName))) {
            String[] urlname = filePath.split("/");
            int len = urlname.length - 1;
            uname = urlname[len];
        }
        try {
            File file = new File(downloadPath + File.separator + uname);
            if (file != null && !file.exists()) {
                file.createNewFile();
            }
            FileOutputStream oputstream = new FileOutputStream(file);
            HttpResponse execute = HttpUtil.createGet((String)filePath).execute();
            InputStream iputstream = execute.bodyStream();
            byte[] buffer = new byte[4096];
            int byteRead = -1;
            while ((byteRead = iputstream.read(buffer)) != -1) {
                ((OutputStream)oputstream).write(buffer, 0, byteRead);
            }
            oputstream.flush();
            iputstream.close();
            ((OutputStream)oputstream).close();
            StringBuffer strb = new StringBuffer();
            FileInputStream fs = new FileInputStream(new File(downloadPath + File.separator + uname));
            InputStreamReader isr = new InputStreamReader((InputStream)fs, "UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String data = "";
            while ((data = br.readLine()) != null) {
                strb.append(data + "\n");
            }
            br.close();
            fs.close();
            isr.close();
            return uname;
        }
        catch (Exception e) {
            System.out.println("\u8bfb\u53d6\u5931\u8d25\uff01");
            e.printStackTrace();
            return null;
        }
    }

    public static void makeWord(Map<?, ?> dataMap, String templateName, String targetPath, String fileName) throws Exception {
        Configuration configuration = new Configuration();
        String testzipPath = FileUtil.class.getClassLoader().getResource("").getPath() + File.separatorChar + "templates" + File.separatorChar;
        configuration.setDirectoryForTemplateLoading(new File(testzipPath + "files"));
        configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        configuration.setDefaultEncoding("UTF-8");
        configuration.setSharedVariable("outPutDocStr", (TemplateModel)new OutPutDocStr());
        Template template = configuration.getTemplate(templateName);
        String outFilePath = targetPath + "data.xml";
        File docFile = new File(outFilePath);
        docFile.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(docFile);
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "utf-8"), 10240);
        template.process(dataMap, (Writer)out);
        if (out != null) {
            ((Writer)out).close();
        }
        if (fos != null) {
            fos.close();
        }
        try {
            ZipInputStream zipInputStream = ZipUtils.wrapZipInputStream(new FileInputStream(new File(testzipPath + "template.zip")));
            ZipOutputStream zipOutputStream = ZipUtils.wrapZipOutputStream(new FileOutputStream(new File(targetPath + fileName + "x")));
            String itemname = "word/document.xml";
            ZipUtils.replaceItem(zipInputStream, zipOutputStream, itemname, new FileInputStream(new File(targetPath + "data.xml")));
            if (docFile != null) {
                docFile.delete();
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public static void makePdfByXcode() {
        long startTime = System.currentTimeMillis();
        String basePath = "e:\\doc4harmFactorTest\\";
        try {
            XWPFDocument document = new XWPFDocument((InputStream)new FileInputStream(new File(basePath + "test.docx")));
            File outFile = new File(basePath + "\u804c\u4e1a\u75c5\u5371\u5bb3\u56e0\u7d20\u76d1\u6d4b\u4e0e\u68c0\u6d4b\u8bc4\u4ef7\u6863\u6848(ZW-JCPJ-2018-0010).pdf");
            outFile.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(outFile);
            PdfOptions options = PdfOptions.create();
            PdfConverter.getInstance().convert(document, (OutputStream)out, (Options)options);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Generate ooxml.pdf with " + (System.currentTimeMillis() - startTime) + " ms.");
    }

    public static File getNetUrl(String netUrl) throws MalformedURLException {
        File file = null;
        file = netUrl.startsWith("https://") ? FileUtil.getNetUrlHttps(netUrl) : FileUtil.getNetUrlHttp(netUrl);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getNetUrlHttp(String netUrl) throws MalformedURLException {
        String fileName = FileUtil.reloadFile(netUrl);
        File file = null;
        InputStream inStream = null;
        OutputStream os = null;
        try {
            file = File.createTempFile("net_url", fileName);
            HttpResponse execute = HttpUtil.createGet((String)netUrl).execute();
            inStream = execute.bodyStream();
            os = new FileOutputStream(file);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = inStream.read(buffer, 0, 8192)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != os) {
                    os.close();
                }
                if (null != inStream) {
                    inStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getNetUrlHttps(String fileUrl) {
        if (!SSRFLeakUtil.securitySSRFUrlCheck(fileUrl)) {
            return null;
        }
        String file_name = FileUtil.reloadFile(fileUrl);
        File file = null;
        FilterInputStream in = null;
        FilterOutputStream out = null;
        try {
            SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
            sslcontext.init(null, new TrustManager[]{new X509TrustUtiil()}, new SecureRandom());
            URL url = new URL(fileUrl);
            HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

                @Override
                public boolean verify(String s, SSLSession sslsession) {
                    return true;
                }
            };
            HttpResponse execute = HttpUtil.createGet((String)fileUrl).execute();
            InputStream inputStream = execute.bodyStream();
            int status = execute.getStatus();
            if (status != 200) {
                throw new Exception("\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25");
            }
            if (StringUtils.isNotEmpty(fileUrl) && !file_name.contains(".") && fileUrl.contains(".")) {
                String[] arr = fileUrl.split("\\.");
                file_name = file_name + arr[arr.length - 1];
            }
            file = File.createTempFile("net_url", file_name);
            in = new DataInputStream(inputStream);
            out = new DataOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            int count = 0;
            while ((count = ((DataInputStream)in).read(buffer)) > 0) {
                ((DataOutputStream)out).write(buffer, 0, count);
            }
            out.close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return file;
    }

    public static String reloadFile(String oleFileName) {
        if (StringUtils.isEmpty((CharSequence)(oleFileName = FileUtil.getFileName(oleFileName)))) {
            return oleFileName;
        }
        if (oleFileName.indexOf(".") == -1) {
            return UUID.randomUUID().toString();
        }
        String[] arr = oleFileName.split("\\.");
        return UUID.randomUUID().toString() + "." + arr[arr.length - 1];
    }

    public static String getFileName(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        String newUrl = url;
        newUrl = newUrl.split("[?]")[0];
        String[] bb = newUrl.split("/");
        String fileName = bb[bb.length - 1];
        return fileName;
    }
}

