/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieUtil {
    private static final Logger log = LoggerFactory.getLogger(CookieUtil.class);

    public static void setCookie(HttpServletResponse response, String name, String value) {
        CookieUtil.setCookie(response, name, value, 86400);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String path) {
        CookieUtil.setCookie(response, name, value, path, 86400);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, int maxAge) {
        CookieUtil.setCookie(response, name, value, "/", maxAge);
    }

    public static void setCookie(HttpServletResponse response, String name, String value, String path, int maxAge) {
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(path);
        cookie.setMaxAge(maxAge);
        try {
            cookie.setValue(URLEncoder.encode(value, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("\u8bbe\u7f6eCookie\u5931\u8d25\uff1a", (Throwable)e);
        }
        response.addCookie(cookie);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        return CookieUtil.getCookie(request, null, name, false);
    }

    public static String getCookie(HttpServletRequest request, HttpServletResponse response, String name) {
        return CookieUtil.getCookie(request, response, name, true);
    }

    public static String getCookie(HttpServletRequest request, HttpServletResponse response, String name, boolean isRemove) {
        String value = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                try {
                    value = URLDecoder.decode(cookie.getValue(), "utf-8");
                    value = value.replace("\n", "");
                    value = value.replace("\r", "");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("\u83b7\u5f97\u6307\u5b9aCookie\u7684\u503c\u5931\u8d25\uff1a", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error("\u83b7\u5f97\u6307\u5b9aCookie\u7684\u503c\u5931\u8d25\uff1a", (Throwable)e);
                }
                if (!isRemove) continue;
                Cookie cookieTemp = new Cookie(name, "");
                cookieTemp.setMaxAge(0);
                cookieTemp.setPath(request.getContextPath());
                response.addCookie(cookieTemp);
            }
        }
        return value;
    }
}

