/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

import cn.smarthse.common.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;

public class CommonUtil {
    private static Gson gson = new Gson();
    private static Pattern FilePattern = Pattern.compile("[\\\\/:*?\"<>|]");
    private static String[] units = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};

    public static String object2json(Object object) {
        return gson.toJson(object);
    }

    public static String codemessage2json(String code, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("msg", message);
        return CommonUtil.getJsonResult(map);
    }

    public static String getJsonResult(Map<String, Object> map) {
        return JSONObject.toJSON(map).toString();
    }

    public static String code2json(String code, Map<String, Object> jsondata) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.putAll(jsondata);
        return gson.toJson(map);
    }

    public static String code2jlist(String code, List list) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("list", gson.toJson((Object)list));
        return gson.toJson(map);
    }

    public static String code2json(String code, String message) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        map.put("msg", message);
        return gson.toJson(map);
    }

    public static String code2data(String code, String objctName, Object objct) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("code", code);
        if (objctName == null || !"".equals(objctName)) {
            objctName = "data";
        }
        map.put(objctName, gson.toJson(objct));
        return gson.toJson(map);
    }

    public static String int2ChineseNum(int num) {
        if (num > 11) {
            return String.valueOf(num);
        }
        return units[num];
    }

    public static String b2mb(long filesize) {
        double r = 0.0;
        String sbyte = "";
        if (filesize > 0x10000000000L) {
            sbyte = "T";
            r = Math.round(filesize / 1024L / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x4B400000L) {
            sbyte = "G";
            r = Math.round(filesize / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x100000L) {
            sbyte = "M";
            r = Math.round(filesize / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 1024L) {
            sbyte = "K";
            r = Math.round(filesize / 1024L * 10L) / 10;
        } else {
            sbyte = "";
            r = filesize;
        }
        return r + sbyte;
    }

    public static long getInt1tomaxRandom(long max) {
        return Math.round(Math.random() * (double)(max - 10L) + 8.0);
    }

    public static List<String> getHtmlImages(String html) {
        String img = "";
        ArrayList<String> pics = new ArrayList<String>();
        String regEx_img = "<img.*src=(.*?)[^>]*?>";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(html);
        while (m_image.find()) {
            img = img + "," + m_image.group();
            Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img);
            while (m.find()) {
                String url = m.group(1);
                url = url.replace("'", "");
                pics.add(url);
            }
        }
        return pics;
    }

    public static String getTextLen(String text, int len) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        if ((text = text.replaceAll("[(/>)<]", "")).length() >= len) {
            return text.substring(0, len - 1) + "...";
        }
        return text;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String local2url(String filePath, String firstIndex) {
        String webfilepath = "/" + filePath.substring(filePath.indexOf(firstIndex), filePath.length());
        try {
            webfilepath = webfilepath.replaceAll("\\\\", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webfilepath;
    }

    public static String getWebFullPath(HttpServletRequest request) {
        StringBuffer path = new StringBuffer();
        path.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath()).append("/");
        return path.toString();
    }

    public static String str2Sort(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        return org.apache.commons.lang.StringUtils.join((Object[])ary, (String)",");
    }

    public static String str2Sort2(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        sort = sort.replaceAll(" ", ",").replaceAll("\\[", "").replaceAll("\\]", ",");
        Object[] ary = sort.split(",");
        Collator comp = Collator.getInstance(Locale.CHINESE);
        Arrays.sort(ary, comp);
        return org.apache.commons.lang.StringUtils.join((Object[])ary, (String)",");
    }

    public static List<String> str2list(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)str)) {
            String[] words;
            for (String word : words = str.split("\\s+|[\uff0c,]")) {
                if (org.apache.commons.lang.StringUtils.isEmpty((String)word)) continue;
                list.add(word);
            }
        }
        return list;
    }

    public static Long str2Long(String str) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)str) && org.apache.commons.lang.StringUtils.isNumeric((String)str)) {
            return Long.parseLong(str);
        }
        return null;
    }

    public static List<Long> str2LongList(String str) {
        return CommonUtil.str2LongList(str, ",");
    }

    public static List<Long> str2LongList(String str, String separator) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)str)) {
            String[] strings = org.apache.commons.lang.StringUtils.splitByWholeSeparator((String)str, (String)separator);
            List<Long> idList = Arrays.stream(strings).filter(s -> org.apache.commons.lang.StringUtils.isNotBlank((String)s) && org.apache.commons.lang.StringUtils.isNumeric((String)s)).map(s -> {
                s = s.trim();
                return Long.parseLong(s);
            }).collect(Collectors.toList());
            return idList;
        }
        return Collections.emptyList();
    }

    public static List<Integer> str2IntegerList(String str, String separator) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)str)) {
            String[] strings = org.apache.commons.lang.StringUtils.splitByWholeSeparator((String)str, (String)separator);
            List<Integer> idList = Arrays.stream(strings).filter(s -> org.apache.commons.lang.StringUtils.isNotBlank((String)s) && org.apache.commons.lang.StringUtils.isNumeric((String)s)).map(s -> {
                s = s.trim();
                return Integer.parseInt(s);
            }).collect(Collectors.toList());
            return idList;
        }
        return Collections.emptyList();
    }

    public static Set<Long> str2LongSet(String str, String separator) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)str)) {
            String[] strings = org.apache.commons.lang.StringUtils.splitByWholeSeparator((String)str, (String)separator);
            Set<Long> idList = Arrays.stream(strings).filter(s -> org.apache.commons.lang.StringUtils.isNotBlank((String)s) && org.apache.commons.lang.StringUtils.isNumeric((String)s)).map(s -> {
                s = s.trim();
                return Long.parseLong(s);
            }).collect(Collectors.toSet());
            return idList;
        }
        return Collections.emptySet();
    }

    public static String str2SortStr(String[] strArr) {
        if (ArrayUtils.isEmpty((Object[])strArr)) {
            return "";
        }
        return CommonUtil.str2SortStr(StringUtils.join((Object[])strArr, (String)","));
    }

    public static String str2SortStr(List<String> strList) {
        if (CollectionUtils.isEmpty(strList)) {
            return "";
        }
        return CommonUtil.str2SortStr(StringUtils.join(strList, (String)","));
    }

    public static String str2SortStr(String str) {
        List<Integer> intList = CommonUtil.str2IntegerList(str, ",");
        List collect1 = intList.stream().distinct().sorted().map(item -> {
            if (item >= 0 && item < 10) {
                return "0" + item;
            }
            return String.valueOf(item);
        }).collect(Collectors.toList());
        return String.join((CharSequence)",", collect1);
    }

    public static Set<Long> str2LongSetMore(String separator, String ... strs) {
        if (ArrayUtils.isNotEmpty((Object[])strs)) {
            HashSet<Long> result = new HashSet<Long>();
            for (String str : strs) {
                Object[] strings = org.apache.commons.lang.StringUtils.splitByWholeSeparator((String)str, (String)separator);
                if (ArrayUtils.isEmpty((Object[])strings)) continue;
                Set idList = Arrays.stream(strings).map(s -> s.trim()).filter(s -> org.apache.commons.lang.StringUtils.isNotBlank((String)s) && org.apache.commons.lang.StringUtils.isNumeric((String)s)).map(s -> Long.parseLong(s)).collect(Collectors.toSet());
                result.addAll(idList);
            }
            return result;
        }
        return Collections.emptySet();
    }

    public static Set<String> str2Set(String str, String separator) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)str)) {
            String[] strings = org.apache.commons.lang.StringUtils.splitByWholeSeparator((String)str, (String)separator);
            Set<String> idList = Arrays.stream(strings).filter(s -> org.apache.commons.lang.StringUtils.isNotBlank((String)s)).collect(Collectors.toSet());
            return idList;
        }
        return Collections.emptySet();
    }

    public static String ary2str(String sort, String replacement) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        StringBuffer result = new StringBuffer();
        for (Object item : ary) {
            if ("[]".equals(replacement)) {
                result.append("[").append((String)item).append("]");
                continue;
            }
            if ("{}".equals(replacement)) {
                result.append("{").append((String)item).append("}");
                continue;
            }
            if ("()".equals(replacement)) {
                result.append("(").append((String)item).append(")");
                continue;
            }
            if ("<>".equals(replacement)) {
                result.append("<").append((String)item).append(">");
                continue;
            }
            result.append((String)item).append(replacement);
        }
        return result.toString();
    }

    public static String[] removeRepeat(String[] arry) {
        List<String> strList = Arrays.asList(arry);
        HashSet<String> strSet = new HashSet<String>(strList);
        String[] newArray = new String[strSet.size()];
        Iterator ite = strSet.iterator();
        int i = 0;
        while (ite.hasNext()) {
            newArray[i] = (String)ite.next();
            ++i;
        }
        return newArray;
    }

    public static boolean checkEmail(String value) {
        return value != null && !"".equals(value) && value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    }

    public static boolean checkTel(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{4}-\\d{8}|\\d{4}-\\d{7}|\\d(3)-\\d(8)");
    }

    public static boolean checkMobile(String value) {
        return value != null && !"".equals(value) && value.matches("^[1][0-9]+\\d{9}");
    }

    public static boolean checkChineseName(String value, int length) {
        return value != null && !"".equals(value) && value.matches("^[\u4e00-\u9fa5]+{1}") && value.length() <= length;
    }

    public static boolean checkBlank(String value) {
        return value != null && !"".equals(value) && value.matches("^\\s*|\\s*{1}");
    }

    public static boolean checkHtmlTag(String value) {
        return value != null && !"".equals(value) && value.matches("<(\\S*?)[^>]*>.*?</\\1>|<.*? />");
    }

    public static boolean checkURL(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-z]+://[^\\s]*");
    }

    public static boolean checkIP(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}");
    }

    public static boolean checkID(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-Z][a-zA-Z0-9_]{4,15}{1}");
    }

    public static boolean checkQQ(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9][0-9]{4,13}");
    }

    public static boolean checkPostCode(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9]\\d{5}(?!\\d)");
    }

    public static boolean checkIDCard(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{15}|\\d{18}|(^\\d{17}(\\d|X|x)$)");
    }

    public static boolean checkLength(String value, int length) {
        return (value == null || "".equals(value.trim()) ? 0 : value.length()) <= length;
    }

    public static boolean checkNull(String value) {
        return value == null || "".equals(value.trim());
    }

    public static void forceUpdatable(Object dest, String[] fieldNames) throws IllegalAccessException, InvocationTargetException {
        if (fieldNames != null && fieldNames.length > 0) {
            CommonUtil.forceUpdatable(dest, Arrays.asList(fieldNames));
        }
    }

    public static void forceUpdatable(Object dest, List<String> fieldNames) throws IllegalAccessException, InvocationTargetException {
        if (fieldNames != null && fieldNames.size() > 0) {
            for (String fieldName : fieldNames) {
                org.apache.commons.beanutils.BeanUtils.copyProperty((Object)dest, (String)(fieldName + "Updable"), (Object)true);
            }
        }
    }

    public static void forceUpdatableIgnore(Object obj, List<String> ignoreNames) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (ignoreNames != null && ignoreNames.size() > 0) {
            for (int i = 0; i < ignoreNames.size(); ++i) {
                ignoreNames.set(i, ignoreNames.get(i) + "Updable");
            }
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.endsWith("Updable") || fields[i].getType() != Boolean.class || ignoreNames.contains(name)) continue;
            PropertyUtils.setProperty((Object)obj, (String)name, (Object)true);
        }
    }

    public static void forceUpdatableIgnore(Object obj, String[] ignoreNames) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List<String> list = new ArrayList<String>();
        if (ignoreNames != null && ignoreNames.length > 0) {
            list = Arrays.asList(ignoreNames);
        }
        CommonUtil.forceUpdatableIgnore(obj, list);
    }

    public static List<String> urlFormat(String url) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String t = matcher.group(1);
            list.add(t);
        }
        return list;
    }

    public static String urlReplace(String url, String paramName, String keyvalue) {
        String fullurl = url;
        List<String> list = CommonUtil.urlFormat(url);
        for (String s : list) {
            if (!s.equals(paramName)) continue;
            fullurl = url.replace("{" + paramName + "}", keyvalue);
        }
        return fullurl;
    }

    public static boolean listIsEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static boolean listIsNotEmpty(List list) {
        return !CommonUtil.listIsEmpty(list);
    }

    public static String distinctAppendStr(String source, String appendStr, String split) {
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)source)) {
            if (source.indexOf(appendStr) == -1) {
                source = source + split + appendStr;
            }
        } else {
            source = appendStr;
        }
        return source;
    }

    public static Set<String> getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        return emptyNames;
    }

    public static void copyPropertiesIgnoreNull(Object src, Object target, String ... ignoreArr) {
        Set<String> nullPropertyNames = CommonUtil.getNullPropertyNames(src);
        if (ArrayUtils.isNotEmpty((Object[])ignoreArr)) {
            for (String ignore : ignoreArr) {
                if (!org.apache.commons.lang.StringUtils.isNotBlank((String)ignore)) continue;
                nullPropertyNames.add(ignore);
            }
        }
        String[] ignoreFieldArr = new String[nullPropertyNames.size()];
        BeanUtils.copyProperties((Object)src, (Object)target, (String[])nullPropertyNames.toArray(ignoreFieldArr));
    }

    public static String getTraceInfo() {
        Object[] stackElements = Thread.currentThread().getStackTrace();
        if (ArrayUtils.isNotEmpty((Object[])stackElements)) {
            StringBuffer sb = new StringBuffer("");
            for (Object t : stackElements) {
                String s = String.format("class: %s , codeLineNumber: %d , method: %s \n", ((StackTraceElement)t).getClassName(), ((StackTraceElement)t).getLineNumber(), ((StackTraceElement)t).getMethodName());
                sb.append(s);
            }
            return sb.toString();
        }
        return "";
    }

    public static File getFile(String ... names) {
        File file = FileUtils.getFile((String[])names);
        return file;
    }

    public static String fileNameFilter(String str) {
        return str == null ? null : FilePattern.matcher(str).replaceAll("");
    }

    public static Integer currStage() {
        LocalDateTime now = LocalDateTime.now();
        LocalDateTime d1 = LocalDateTime.of(2023, 5, 1, 0, 0, 0);
        LocalDateTime d2 = LocalDateTime.of(2023, 9, 1, 0, 0, 0);
        LocalDateTime d3 = LocalDateTime.of(2023, 12, 1, 20, 0, 20);
        if (now.isBefore(d1)) {
            return 1;
        }
        if (now.isAfter(d1) && now.isBefore(d2) || now.isEqual(d1)) {
            return 2;
        }
        if (now.isAfter(d2) && now.isBefore(d3) || now.isEqual(d2)) {
            return 3;
        }
        return null;
    }

    public static boolean gradeEndTime() {
        LocalDateTime d1;
        LocalDateTime now = LocalDateTime.now();
        return !now.isBefore(d1 = LocalDateTime.of(2024, 7, 1, 23, 59, 59));
    }
}

