/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.util;

public class BaiDuMapUtil {
    static double DEF_PI = 3.14159265359;
    static double DEF_2PI = 6.28318530712;
    static double DEF_PI180 = 0.01745329252;
    static double DEF_R = 6370693.5;

    public static double GetShortDistance(double lon1, double lat1, double lon2, double lat2) {
        double ew1 = lon1 * DEF_PI180;
        double ns1 = lat1 * DEF_PI180;
        double ew2 = lon2 * DEF_PI180;
        double ns2 = lat2 * DEF_PI180;
        double dew = ew1 - ew2;
        if (dew > DEF_PI) {
            dew = DEF_2PI - dew;
        } else if (dew < -DEF_PI) {
            dew = DEF_2PI + dew;
        }
        double dx = DEF_R * Math.cos(ns1) * dew;
        double dy = DEF_R * (ns1 - ns2);
        double distance = Math.sqrt(dx * dx + dy * dy);
        return distance;
    }

    public static double GetLongDistance(double lon1, double lat1, double lon2, double lat2) {
        double ew1 = lon1 * DEF_PI180;
        double ns1 = lat1 * DEF_PI180;
        double ew2 = lon2 * DEF_PI180;
        double ns2 = lat2 * DEF_PI180;
        double distance = Math.sin(ns1) * Math.sin(ns2) + Math.cos(ns1) * Math.cos(ns2) * Math.cos(ew1 - ew2);
        if (distance > 1.0) {
            distance = 1.0;
        } else if (distance < -1.0) {
            distance = -1.0;
        }
        distance = DEF_R * Math.acos(distance);
        return distance;
    }
}

