/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.listener;

import javax.servlet.ServletContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.ConfigurableWebEnvironment;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;

public class WebContextListener
extends ContextLoaderListener {
    public static final String ACTUALIZE_CONFIG_LOCATION_PARAM = "actualizeContextConfigLocation";

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        return super.initWebApplicationContext(servletContext);
    }

    protected void configureAndRefreshWebApplicationContext(ConfigurableWebApplicationContext wac, ServletContext sc) {
        ConfigurableEnvironment env;
        if (ObjectUtils.identityToString((Object)wac).equals(wac.getId())) {
            String idParam = sc.getInitParameter("contextId");
            if (idParam != null) {
                wac.setId(idParam);
            } else {
                wac.setId(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX + ObjectUtils.getDisplayString((Object)sc.getContextPath()));
            }
        }
        wac.setServletContext(sc);
        String configLocationParam = "";
        configLocationParam = sc.getInitParameter("contextConfigLocation");
        if (configLocationParam != null) {
            wac.setConfigLocation(configLocationParam);
        }
        if ((env = wac.getEnvironment()) instanceof ConfigurableWebEnvironment) {
            ((ConfigurableWebEnvironment)env).initPropertySources(sc, null);
        }
        this.customizeContext(sc, wac);
        wac.refresh();
    }
}

