/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.interprecetor.ehcache;

import java.util.Enumeration;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.constructs.web.AlreadyCommittedException;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.filter.FilterNonReentrantException;
import net.sf.ehcache.constructs.web.filter.SimplePageCachingFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageEhCacheFilter
extends SimplePageCachingFilter {
    private static final Logger log = LoggerFactory.getLogger(PageEhCacheFilter.class);
    private static final String FILTER_URL_PATTERNS = "patterns";
    private static String[] cacheURLs;

    private void init() throws CacheException {
        String patterns = this.filterConfig.getInitParameter(FILTER_URL_PATTERNS);
        cacheURLs = StringUtils.split((String)patterns, (String)",");
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws AlreadyGzippedException, AlreadyCommittedException, FilterNonReentrantException, LockTimeoutException, Exception {
        if (cacheURLs == null) {
            this.init();
        }
        String url = request.getRequestURI();
        boolean flag = false;
        if (cacheURLs != null && cacheURLs.length > 0) {
            for (String cacheURL : cacheURLs) {
                if (!url.contains(cacheURL.trim())) continue;
                flag = true;
                break;
            }
        }
        if (flag) {
            String query = request.getQueryString();
            if (query != null) {
                query = "?" + query;
            }
            log.info("\u5f53\u524d\u8bf7\u6c42\u88ab\u7f13\u5b58\uff1a" + url + query);
            super.doFilter(request, response, chain);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean headerContains(HttpServletRequest request, String header, String value) {
        this.logRequestHeaders(request);
        Enumeration accepted = request.getHeaders(header);
        while (accepted.hasMoreElements()) {
            String headerValue = (String)accepted.nextElement();
            if (headerValue.indexOf(value) == -1) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptsGzipEncoding(HttpServletRequest request) {
        boolean ie6 = this.headerContains(request, "User-Agent", "MSIE 6.0");
        boolean ie7 = this.headerContains(request, "User-Agent", "MSIE 7.0");
        return this.acceptsEncoding(request, "gzip") || ie6 || ie7;
    }
}

