/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.interprecetor;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HtmlUtil;
import java.util.Iterator;
import java.util.List;
import javax.cn.smarthse.modules.health.exception.HealthException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class MultipartRequestInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(MultipartRequestInterceptor.class);

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        if (request instanceof MultipartHttpServletRequest) {
            MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
            Iterator fileNames = multipartRequest.getFileNames();
            while (fileNames.hasNext()) {
                String fieldName = (String)fileNames.next();
                MultipartFile file = multipartRequest.getFile(fieldName);
                if (file == null || file.isEmpty()) continue;
                String fileName = file.getOriginalFilename();
                List split = StrUtil.split((CharSequence)fileName, (CharSequence)".");
                if (split.size() != 2) {
                    throw new HealthException("\u6587\u4ef6\u540d\u4e0d\u53ef\u5305\u542b\u591a\u4e2a'.'\u7b26\u53f7\uff01\u3002");
                }
                String fileNameExExt = (String)split.get(0);
                if (!StrUtil.isBlank((CharSequence)(fileNameExExt = HtmlUtil.cleanHtmlTag((String)HtmlUtil.filter((String)fileNameExExt))))) continue;
                throw new HealthException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff01\u3002");
            }
        }
        return true;
    }
}

