/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.interprecetor;

import cn.smarthse.common.util.StringUtils;
import java.net.URI;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.resource.ResourceHttpRequestHandler;

public class CsrfInterceptor
extends HandlerInterceptorAdapter {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Value(value="${allowedDomains}")
    private String allowedDomains;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof ResourceHttpRequestHandler) {
            return true;
        }
        List<String> allowedDomainList = StringUtils.parseToStringList(this.allowedDomains, ",");
        String origin = request.getHeader("Origin");
        String referer = request.getHeader("Referer");
        String serverName = request.getServerName();
        if (StringUtils.isNotBlank((CharSequence)origin)) {
            String originDomain = new URI(origin).getHost();
            if (!origin.contains(serverName) && !allowedDomainList.contains(originDomain)) {
                response.setStatus(403);
                this.logger.error("csrf\u653b\u51fb\u62e6\u622a--origin:{}, serverName:{}", (Object)origin, (Object)serverName);
                return false;
            }
        }
        if (StringUtils.isBlank((CharSequence)origin) && StringUtils.isNotBlank((CharSequence)referer)) {
            String refererDomain = new URI(referer).getHost();
            if (!referer.contains(serverName) && !allowedDomainList.contains(refererDomain)) {
                response.setStatus(403);
                this.logger.error("csrf\u653b\u51fb\u62e6\u622a--referer:{}, serverName:{}", (Object)origin, (Object)serverName);
                return false;
            }
        }
        return true;
    }
}

