/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.zk;

import java.util.function.Consumer;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ZkUtils {
    public static CuratorFramework getConnection(String zkAddress, String namespace) {
        CuratorFramework client = CuratorFrameworkFactory.builder().connectString(zkAddress).sessionTimeoutMs(5000).connectionTimeoutMs(5000).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(1000, 3)).namespace(namespace).build();
        client.start();
        return client;
    }

    public static void createNode(CuratorFramework client, String zkpath, CreateMode createMode) throws Exception {
        Stat stat = (Stat)client.checkExists().forPath(zkpath);
        if (stat == null) {
            String string = (String)((ACLBackgroundPathAndBytesable)client.create().creatingParentContainersIfNeeded().withMode(createMode)).forPath(zkpath);
        }
    }

    public static void watch(CuratorFramework client, String zkpath, final Consumer<String> c) throws Exception {
        CuratorCache nodecache = CuratorCache.build((CuratorFramework)client, (String)zkpath, (CuratorCache.Options[])new CuratorCache.Options[0]);
        nodecache.listenable().addListener((Object)new CuratorCacheListener(){

            public void event(CuratorCacheListener.Type type, ChildData oldData, ChildData data) {
                c.accept(new String(data.getData()));
            }
        });
        nodecache.start();
    }

    public static String getData(CuratorFramework client, String path) {
        try {
            String str = new String((byte[])client.getData().forPath(path));
            return str;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

