/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.zk;

import cn.smarthse.common.framework.zk.WebSetInfo;
import cn.smarthse.common.framework.zk.ZkUtils;
import cn.smarthse.common.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import org.apache.curator.framework.CuratorFramework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkHelper {
    private static final Logger log = LoggerFactory.getLogger(ZkHelper.class);
    private String zkAddress;
    private static final String rootPath = "smarthse";
    private static final String zkpath = "/webinfo";
    private volatile WebSetInfo webSetInfo = null;

    public void init() {
        this.zkAddress = StringUtils.replace((String)this.zkAddress, (String)"zookeeper://", (String)"");
        CuratorFramework connection = ZkUtils.getConnection(this.zkAddress, rootPath);
        try {
            ZkUtils.watch(connection, zkpath, data -> {
                this.webSetInfo = (WebSetInfo)JSONObject.parseObject((String)data, WebSetInfo.class);
            });
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316ZkHelper \u62a5\u9519\uff0c ", (Throwable)e);
        }
    }

    public WebSetInfo getWebSetInfo() {
        if (this.webSetInfo == null) {
            CuratorFramework connection = ZkUtils.getConnection(this.zkAddress, rootPath);
            String data = ZkUtils.getData(connection, zkpath);
            this.webSetInfo = (WebSetInfo)JSONObject.parseObject((String)data, WebSetInfo.class);
        }
        return this.webSetInfo;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public void setWebSetInfo(WebSetInfo webSetInfo) {
        this.webSetInfo = webSetInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZkHelper)) {
            return false;
        }
        ZkHelper other = (ZkHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$zkAddress = this.getZkAddress();
        String other$zkAddress = other.getZkAddress();
        if (this$zkAddress == null ? other$zkAddress != null : !this$zkAddress.equals(other$zkAddress)) {
            return false;
        }
        WebSetInfo this$webSetInfo = this.getWebSetInfo();
        WebSetInfo other$webSetInfo = other.getWebSetInfo();
        return !(this$webSetInfo == null ? other$webSetInfo != null : !((Object)this$webSetInfo).equals(other$webSetInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZkHelper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $zkAddress = this.getZkAddress();
        result = result * 59 + ($zkAddress == null ? 43 : $zkAddress.hashCode());
        WebSetInfo $webSetInfo = this.getWebSetInfo();
        result = result * 59 + ($webSetInfo == null ? 43 : ((Object)$webSetInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ZkHelper(zkAddress=" + this.getZkAddress() + ", webSetInfo=" + this.getWebSetInfo() + ")";
    }
}

