/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.web.repeatform;

import cn.smarthse.common.framework.database.persistence.ResponseData;
import cn.smarthse.common.framework.enums.ResponseStateEnum;
import cn.smarthse.common.framework.mapper.JsonMapper;
import cn.smarthse.common.framework.web.repeatform.RepeatUrlFormData;
import cn.smarthse.common.util.date.DateUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class RepeatUrlFormInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RepeatUrlFormInterceptor.class);
    private static final String repeatText = JsonMapper.toJsonString(new ResponseData<String>(ResponseStateEnum.warning, "\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\uff01"));
    @Autowired
    private CacheManager cacheManager;
    private static final String REPEAT_SUBMIT_CACHE = "repeatSubmitCache";
    private static final String EXCLUTE_PARAM = "excluteParam";
    private boolean enable;
    private String start;
    private String end;
    private String jumpUrl;
    Cache repeatsubmitcache = null;
    private static ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    @PostConstruct
    public void init() {
        this.repeatsubmitcache = this.cacheManager.getCache(REPEAT_SUBMIT_CACHE);
        if (this.repeatsubmitcache == null) {
            this.cacheManager.addCache(REPEAT_SUBMIT_CACHE);
            this.repeatsubmitcache = this.cacheManager.getCache(REPEAT_SUBMIT_CACHE);
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.enable) {
            LocalDateTime now = LocalDateTime.now();
            String nowDate = DateUtil.getNowDate("yyyy-MM-dd");
            LocalDateTime startDate = DateUtil.parseDateTime(nowDate + " " + this.start, "yyyy-MM-dd HH:mm:ss");
            LocalDateTime endDate = DateUtil.parseDateTime(nowDate + " " + this.end, "yyyy-MM-dd HH:mm:ss");
            if (now.isAfter(startDate) || now.isBefore(endDate)) {
                response.sendRedirect(this.jumpUrl);
                return false;
            }
        }
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RepeatUrlFormData annotation = method.getAnnotation(RepeatUrlFormData.class);
            ResponseBody bodytype = method.getAnnotation(ResponseBody.class);
            if (annotation != null) {
                int delaySeconds = annotation.delaySeconds();
                if (this.repeatDataValidator(request, delaySeconds)) {
                    if (bodytype != null) {
                        try {
                            response.reset();
                            response.setContentType("application/json");
                            response.setCharacterEncoding("utf-8");
                            response.getWriter().print(repeatText);
                        }
                        catch (IOException iOException) {}
                    } else {
                        log.info("\u91cd\u590d\u8bf7\u6c42\u88ab\u62e6\u622a\uff0c\u8be5\u8bf7\u6c42\u4e0d\u5f80\u4e0b\u6267\u884c...url:{}, \u7528\u6237\uff1a{}", (Object)request.getRequestURI(), (Object)this.getLoginUserName());
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean repeatDataValidator(HttpServletRequest httpServletRequest, int delaySeconds) {
        Map<String, String> parameterMap = this.convertMap(httpServletRequest);
        String cacheKey = this.generateCacheKey(httpServletRequest);
        ReentrantReadWriteLock.WriteLock writeLock = lock.writeLock();
        writeLock.lock();
        try {
            Element element = this.repeatsubmitcache.get((Serializable)((Object)cacheKey));
            if (element == null) {
                element = new Element((Object)cacheKey, parameterMap);
                element.setTimeToLive(delaySeconds);
                this.repeatsubmitcache.put(element);
                boolean bl = false;
                return bl;
            }
            long expirationTime = element.getExpirationTime();
            Object objectValue = element.getObjectValue();
            if (parameterMap != null && parameterMap.equals(objectValue)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    public Map<String, String> convertMap(HttpServletRequest httpServletRequest) {
        Set keySet;
        HashMap parameterMap = new HashMap(httpServletRequest.getParameterMap());
        String excluteParamter = httpServletRequest.getParameter(EXCLUTE_PARAM);
        Object[] excluteParamterarr = StringUtils.splitByWholeSeparator((String)excluteParamter, (String)",");
        HashSet<Object> excluteParamterSet = new HashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])excluteParamterarr)) {
            excluteParamterSet = new HashSet<Object>(Arrays.asList(excluteParamterarr));
        }
        excluteParamterSet.add("timestamp");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (MapUtils.isNotEmpty(parameterMap) && CollectionUtils.isNotEmpty(keySet = parameterMap.keySet())) {
            for (String key : keySet) {
                if (excluteParamterSet.contains(key)) continue;
                Object[] strarr = (String[])parameterMap.get(key);
                resultMap.put(key, StringUtils.join((Object[])strarr, (String)","));
            }
        }
        return resultMap;
    }

    private String generateCacheKey(HttpServletRequest httpServletRequest) {
        String url = httpServletRequest.getRequestURI();
        String principal = this.getLoginUserName();
        return url + principal;
    }

    private String getLoginUserName() {
        Object principal = SecurityUtils.getSubject().getPrincipal();
        if (principal == null) {
            return "";
        }
        return principal.toString();
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public String getJumpUrl() {
        return this.jumpUrl;
    }

    public void setJumpUrl(String jumpUrl) {
        this.jumpUrl = jumpUrl;
    }
}

