/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.singletask;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleTaskLock {
    private static final Logger log = LoggerFactory.getLogger(SingleTaskLock.class);
    private static final ConcurrentHashMap<String, Object> LOCK_CACHE = new ConcurrentHashMap(200);

    private SingleTaskLock() {
    }

    public static SingleTaskLock getInstance() {
        return SingletonInstance.INSTANCE;
    }

    public static String handleKey(String param) {
        return DigestUtils.md5Hex((String)(param == null ? "" : param));
    }

    public boolean lock(String key, Object value) {
        return Objects.isNull(LOCK_CACHE.putIfAbsent(key, value));
    }

    public void unLock(boolean lock, String key) {
        if (lock) {
            LOCK_CACHE.remove(key);
        }
    }

    private static class SingletonInstance {
        private static final SingleTaskLock INSTANCE = new SingleTaskLock();

        private SingletonInstance() {
        }
    }
}

