/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.singletask;

import cn.smarthse.common.framework.singletask.OgnlWrapper;
import cn.smarthse.common.framework.singletask.SingleTaskLock;
import cn.smarthse.common.framework.singletask.SingleTaskPolicyEnum;
import cn.smarthse.common.framework.singletask.singleTask;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SingleTaskAspect {
    private static final Logger log = LoggerFactory.getLogger(SingleTaskAspect.class);
    private static final Object PRESENT = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(cn.smarthse.common.framework.singletask.singleTask)")
    public Object handleResubmit(ProceedingJoinPoint joinPoint) throws Throwable {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        singleTask annotation = method.getAnnotation(singleTask.class);
        Object[] expressions = annotation.expressions();
        SingleTaskPolicyEnum singleTaskPolicyEnum = annotation.singleTaskPolicy();
        Object[] pointArgs = joinPoint.getArgs();
        if (ArrayUtils.isEmpty((Object[])expressions) || ArrayUtils.isEmpty((Object[])pointArgs)) {
            log.warn("\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff0c \u4e0d\u6267\u884c\u62e6\u622a\u903b\u8f91...");
            return joinPoint.proceed();
        }
        String name = joinPoint.getSignature().getName();
        String declaringTypeName = joinPoint.getSignature().getDeclaringTypeName();
        String value = "";
        try {
            value = this.getValueByExpression(joinPoint, (String[])expressions);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u53c2\u6570\u5931\u8d25{}, \u8bf7\u68c0\u67e5\u8868\u8fbe\u5f0f expression:{}", (Object)e, (Object)expressions);
            value = null;
        }
        if (value == null) {
            log.info("\u6267\u884c\u5355\u4efb\u52a1\u65b9\u6cd5, \u672a\u4ece\u53c2\u6570\u5217\u8868\u4e2d\u83b7\u53d6\u5230\u8868\u8fbe\u5f0f\u7684\u503c\uff0c \u76f4\u63a5\u653e\u884c");
            return joinPoint.proceed();
        }
        String lockkey = declaringTypeName + "." + name + ":" + value;
        boolean lock = false;
        try {
            lock = SingleTaskLock.getInstance().lock(lockkey, PRESENT);
            if (lock) {
                log.info("\u6267\u884c\u5355\u4efb\u52a1\u65b9\u6cd5\uff1alockkey\uff1a{}", (Object)lockkey);
                Object object = joinPoint.proceed();
                return object;
            }
            if (singleTaskPolicyEnum == SingleTaskPolicyEnum.AbortPolicy) {
                log.warn("SingleTaskAspect\u91cd\u590d\u6267\u884c\uff0c \u8fd9\u91cc\u76f4\u63a5\u62d2\u7edd\uff0c lockkey\uff1a{}", (Object)lockkey);
                Object var12_14 = null;
                return var12_14;
            }
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            SingleTaskLock.getInstance().unLock(lock, lockkey);
        }
    }

    public String getValueByExpression(ProceedingJoinPoint joinPoint, String[] expressions) {
        Object[] pointArgs = joinPoint.getArgs();
        String[] names = ((CodeSignature)joinPoint.getSignature()).getParameterNames();
        if (ArrayUtils.isNotEmpty((Object[])pointArgs)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            for (int i = 0; i < pointArgs.length; ++i) {
                data.put(names[i], pointArgs[i]);
            }
            OgnlWrapper ognlWrapper = new OgnlWrapper(data);
            StringBuffer sb = new StringBuffer();
            for (String expression : expressions) {
                String value;
                if (StringUtils.isBlank((CharSequence)expression) || (value = ognlWrapper.getString(expression)) == null) continue;
                sb.append(value + "-");
            }
            if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                return sb.toString();
            }
        }
        return null;
    }
}

