/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.singletask;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlWrapper {
    private static Logger logger = LoggerFactory.getLogger(OgnlWrapper.class);
    private static ObjectMapper om = new ObjectMapper();
    private Map<String, Object> payload;

    public OgnlWrapper(Map<String, Object> playload) {
        this.payload = playload;
    }

    public OgnlWrapper(Object playload) {
        this.payload = (Map)om.convertValue(playload, Map.class);
    }

    public <T> T get(String expression) {
        try {
            return (T)Ognl.getValue((String)expression, this.payload);
        }
        catch (OgnlException e) {
            logger.trace(String.format("get value with expression:[%s] due to error, return null instead of", expression), (Throwable)e);
            return null;
        }
    }

    public Long getLong(String expression) {
        try {
            Object obj = Ognl.getValue((String)expression, this.payload);
            if (null == obj) {
                return null;
            }
            try {
                return Long.parseLong(obj.toString());
            }
            catch (NumberFormatException nfe) {
                logger.warn(String.format("get value with expression:[%s] due to error, return null. value[%s] cannot be cast to java.lang.Long", expression, obj.toString()));
                return null;
            }
        }
        catch (OgnlException e) {
            logger.trace(String.format("get value with expression:[%s] due to error, return null instead of", expression), (Throwable)e);
            return null;
        }
    }

    public String getString(String expression) {
        try {
            Object obj = Ognl.getValue((String)expression, this.payload);
            if (null == obj) {
                return null;
            }
            return obj.toString();
        }
        catch (OgnlException e) {
            logger.trace(String.format("get value with expression:[%s] due to error, return null instead of", expression), (Throwable)e);
            return null;
        }
    }

    public Integer getInt(String expression) {
        try {
            Object obj = Ognl.getValue((String)expression, this.payload);
            if (null == obj) {
                return null;
            }
            try {
                return Integer.parseInt(obj.toString());
            }
            catch (NumberFormatException nfe) {
                logger.warn(String.format("get value with expression:[%s] due to error, return null. value[%s] cannot be cast to java.lang.Integer", expression, obj.toString()));
                return null;
            }
        }
        catch (OgnlException e) {
            logger.trace(String.format("get value with expression:[%s] due to error, return null instead of", expression), (Throwable)e);
            return null;
        }
    }

    public String toString() {
        return String.format("OgnlWrapper[%s]", this.payload.toString());
    }
}

