/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.security.shiro.filter;

import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.DefaultSessionKey;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KickoutSessionControlFilter
extends AccessControlFilter {
    private static Logger log = LoggerFactory.getLogger(KickoutSessionControlFilter.class);
    private String kickoutUrl;
    private boolean kickoutAfter = false;
    private int maxSession = 1;
    private SessionManager sessionManager;
    private Cache<String, Deque<Serializable>> cache;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        return false;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (!subject.isAuthenticated() && !subject.isRemembered()) {
            return true;
        }
        Session session = subject.getSession();
        String username = subject.getPrincipal().toString();
        Serializable sessionId = session.getId();
        LinkedList<Serializable> deque = (LinkedList<Serializable>)this.cache.get((Object)username);
        if (deque == null) {
            deque = new LinkedList<Serializable>();
            this.cache.put((Object)username, deque);
        }
        if (!deque.contains(sessionId) && session.getAttribute((Object)"kickout") == null) {
            deque.push(sessionId);
        }
        while (deque.size() > this.maxSession) {
            log.info("\u8e22\u51fa\u4e4b\u524d\u7684\u7528\u6237");
            Serializable kickoutSessionId = null;
            kickoutSessionId = this.kickoutAfter ? (Serializable)deque.removeFirst() : (Serializable)deque.removeLast();
            try {
                Session kickoutSession = this.sessionManager.getSession((SessionKey)new DefaultSessionKey(kickoutSessionId));
                if (kickoutSession == null) continue;
                kickoutSession.setAttribute((Object)"kickout", (Object)true);
            }
            catch (Exception exception) {}
        }
        if (session.getAttribute((Object)"kickout") != null) {
            try {
                subject.logout();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveRequest(request);
            WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)this.kickoutUrl);
            return false;
        }
        return true;
    }

    public String getKickoutUrl() {
        return this.kickoutUrl;
    }

    public void setKickoutUrl(String kickoutUrl) {
        this.kickoutUrl = kickoutUrl;
    }

    public boolean isKickoutAfter() {
        return this.kickoutAfter;
    }

    public void setKickoutAfter(boolean kickoutAfter) {
        this.kickoutAfter = kickoutAfter;
    }

    public int getMaxSession() {
        return this.maxSession;
    }

    public void setMaxSession(int maxSession) {
        this.maxSession = maxSession;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public Cache<String, Deque<Serializable>> getCache() {
        return this.cache;
    }

    public void setCache(Cache<String, Deque<Serializable>> cache) {
        this.cache = cache;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache("shiro-kickout-session");
    }
}

