/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.security.shiro;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;

public class ShiroAuthorizingCredentialsMatcher
extends HashedCredentialsMatcher {
    private Cache<String, AtomicInteger> passwordRetryCache;
    private int retryCount = 3;
    private int retryFailCount = 10;
    private String passwordRetryCacheName = "passwordRetryCache";

    public ShiroAuthorizingCredentialsMatcher(CacheManager cacheManager) {
        this.passwordRetryCache = cacheManager.getCache(this.passwordRetryCacheName);
    }

    public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
        int currentCount;
        String username = (String)token.getPrincipal();
        AtomicInteger retryAtomicCount = (AtomicInteger)this.passwordRetryCache.get((Object)username);
        if (retryAtomicCount == null) {
            retryAtomicCount = new AtomicInteger(0);
            this.passwordRetryCache.put((Object)username, (Object)retryAtomicCount);
        }
        if ((currentCount = retryAtomicCount.incrementAndGet()) > this.retryFailCount) {
            throw new ExcessiveAttemptsException();
        }
        boolean matches = super.doCredentialsMatch(token, info);
        if (matches) {
            this.passwordRetryCache.remove((Object)username);
        } else if (currentCount > this.retryCount) {
            throw new LockedAccountException();
        }
        return matches;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryFailCount() {
        return this.retryFailCount;
    }

    public void setRetryFailCount(int retryFailCount) {
        this.retryFailCount = retryFailCount;
    }

    public Cache<String, AtomicInteger> getPasswordRetryCache() {
        return this.passwordRetryCache;
    }

    public void setPasswordRetryCache(Cache<String, AtomicInteger> passwordRetryCache) {
        this.passwordRetryCache = passwordRetryCache;
    }

    public String getPasswordRetryCacheName() {
        return this.passwordRetryCacheName;
    }

    public void setPasswordRetryCacheName(String passwordRetryCacheName) {
        this.passwordRetryCacheName = passwordRetryCacheName;
    }

    public void clearLockedAccount(String username) {
        this.passwordRetryCache.remove((Object)username);
    }
}

