/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.redis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RLock;
import org.redisson.api.RPriorityBlockingDeque;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class RedisClient {
    private static final Logger log = LoggerFactory.getLogger(RedisClient.class);
    private RedissonClient redissonClient;
    private RedisTemplate redisTemplate;

    private RedisClient() {
    }

    public RedisClient(RedissonClient redissonClient, RedisTemplate redisTemplate) {
        this.redissonClient = redissonClient;
        this.redisTemplate = redisTemplate;
    }

    public boolean expire(String key, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.expire((Object)key, time, TimeUnit.SECONDS);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public boolean hasKey(String key) {
        try {
            return this.redisTemplate.hasKey((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void del(String ... key) {
        if (key != null && key.length > 0) {
            if (key.length == 1) {
                this.redisTemplate.delete((Object)key[0]);
            } else {
                this.redisTemplate.delete((Collection)CollectionUtils.arrayToList((Object)key));
            }
        }
    }

    public void del(Integer key) {
        this.del(String.valueOf(key));
    }

    public void del(Collection keys) {
        if (!CollectionUtils.isEmpty((Collection)keys) && keys.size() > 0) {
            this.redisTemplate.delete(keys);
        }
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public Object get(Integer key) {
        return this.get(String.valueOf(key));
    }

    public List<Object> listByPrefix(String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return null;
        }
        ScanOptions options = ScanOptions.scanOptions().match(prefix + "*").count(200L).build();
        HashSet<String> keys = new HashSet<String>();
        try (Cursor cursor = this.redisTemplate.scan(options);){
            while (cursor.hasNext()) {
                String key = (String)cursor.next();
                keys.add(key);
            }
        }
        List values = this.redisTemplate.opsForValue().multiGet(keys);
        return values;
    }

    public long delPrefix(String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return 0L;
        }
        ScanOptions options = ScanOptions.scanOptions().match(prefix + "*").count(200L).build();
        ArrayList<String> keysToDelete = new ArrayList<String>(300);
        long totalDeleted = 0L;
        try (Cursor cursor = this.redisTemplate.scan(options);){
            while (cursor.hasNext()) {
                String key = (String)cursor.next();
                keysToDelete.add(key);
                if (keysToDelete.size() < 200) continue;
                totalDeleted += this.redisTemplate.delete(keysToDelete).longValue();
                keysToDelete.clear();
            }
            if (!keysToDelete.isEmpty()) {
                totalDeleted += this.redisTemplate.delete(keysToDelete).longValue();
            }
        }
        return totalDeleted;
    }

    public Map<String, Object> mapByPrefix(String prefix) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            return null;
        }
        Set keys = this.redisTemplate.keys((Object)prefix.concat("*"));
        HashMap<String, Object> mapdata = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty((Collection)keys)) {
            return mapdata;
        }
        for (String key : keys) {
            Object o = this.get(key);
            mapdata.put(key, o);
        }
        return mapdata;
    }

    public boolean set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(Integer key, Object value) {
        return this.set(String.valueOf(key), value);
    }

    public boolean set(String key, Object value, long time) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, TimeUnit.SECONDS);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, Object value, long time, TimeUnit unit) {
        try {
            if (time > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, time, unit);
            } else {
                this.set(key, value);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long incr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, delta);
    }

    public long decr(String key, long delta) {
        if (delta < 0L) {
            throw new RuntimeException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b\u5927\u4e8e0");
        }
        return this.redisTemplate.opsForValue().increment((Object)key, -delta);
    }

    public Object hget(String key, String item) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)item);
    }

    public Map<Object, Object> hmget(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public boolean hmset(String key, Map<String, Object> map) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hmset(String key, Map<String, Object> map, long time) {
        try {
            this.redisTemplate.opsForHash().putAll((Object)key, map);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean hset(String key, String item, Object value, long time) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)item, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void hdel(String key, Object ... item) {
        this.redisTemplate.opsForHash().delete((Object)key, item);
    }

    public boolean hHasKey(String key, String item) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, (Object)item);
    }

    public double hincr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, by);
    }

    public double hdecr(String key, String item, double by) {
        return this.redisTemplate.opsForHash().increment((Object)key, (Object)item, -by);
    }

    public Set<Object> sGet(String key) {
        try {
            return this.redisTemplate.opsForSet().members((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean sHasKey(String key, Object value) {
        try {
            return this.redisTemplate.opsForSet().isMember((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long sSet(String key, Object ... values) {
        try {
            return this.redisTemplate.opsForSet().add((Object)key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sSetAndTime(String key, long time, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().add((Object)key, values);
            if (time > 0L) {
                this.expire(key, time);
            }
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long sGetSetSize(String key) {
        try {
            return this.redisTemplate.opsForSet().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public long setRemove(String key, Object ... values) {
        try {
            Long count = this.redisTemplate.opsForSet().remove((Object)key, values);
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public List<Object> lGet(String key, long start, long end) {
        try {
            return this.redisTemplate.opsForList().range((Object)key, start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public long lGetListSize(String key) {
        try {
            return this.redisTemplate.opsForList().size((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Object lGetIndex(String key, long index) {
        try {
            return this.redisTemplate.opsForList().index((Object)key, index);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lSet(String key, Object value) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, Object value, long time) {
        try {
            this.redisTemplate.opsForList().rightPush((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lSet(String key, List<Object> value, long time) {
        try {
            this.redisTemplate.opsForList().rightPushAll((Object)key, value);
            if (time > 0L) {
                this.expire(key, time);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean lUpdateIndex(String key, long index, Object value) {
        try {
            this.redisTemplate.opsForList().set((Object)key, index, value);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public long lRemove(String key, long count, Object value) {
        try {
            Long remove = this.redisTemplate.opsForList().remove((Object)key, count, value);
            return remove;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public Set keys(String key) {
        try {
            return this.redisTemplate.keys((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String generateCacheKey(Object ... objs) {
        if (ArrayUtils.isNotEmpty((Object[])objs)) {
            return Arrays.stream(objs).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(":"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String cacheName, String key, long timeout, Supplier<T> function) {
        String cacheKey = cacheName + ":" + key;
        Object value = this.redisTemplate.opsForValue().get((Object)cacheKey);
        if (Objects.nonNull(value)) {
            return (T)value;
        }
        log.debug("\u672a\u627e\u5230\u7f13\u5b58key\uff1a'{}'", (Object)cacheKey);
        RLock lock = this.redissonClient.getLock(cacheKey + ":hot");
        lock.lock();
        try {
            value = this.redisTemplate.opsForValue().get((Object)cacheKey);
            if (Objects.nonNull(value)) {
                Object object = value;
                return (T)object;
            }
            log.debug("\u88ab\u4e0a\u9501\u7684\u7f13\u5b58key\uff1a'{}'", (Object)cacheKey);
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            value = function.get();
            stopWatch.stop();
            log.debug("\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\u6570\u636e\u3002 key:{}, \u6570\u636e\u52a0\u8f7d\u8017\u65f6\uff1a{}ms", (Object)cacheKey, (Object)stopWatch.getTime());
            if (Objects.nonNull(value)) {
                if (timeout > 0L) {
                    this.set(cacheKey, value, timeout + (long)new Random().nextInt(300));
                } else {
                    this.set(cacheKey, value);
                }
            }
        }
        finally {
            lock.unlock();
        }
        return (T)value;
    }

    public <T> T get(String cacheName, String key, long timeout, Supplier<T> function, boolean enableCache) {
        if (!enableCache) {
            T value = function.get();
            return value;
        }
        return this.get(cacheName, key, timeout, function);
    }

    public <T> boolean addDelayQueue(@NonNull T value, @NonNull long delay, @NonNull TimeUnit timeUnit, @NonNull String queueCode) {
        if (StringUtils.isBlank((CharSequence)queueCode)) {
            return false;
        }
        try {
            RPriorityBlockingDeque priorityBlockingDeque = this.redissonClient.getPriorityBlockingDeque(queueCode);
            RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)priorityBlockingDeque);
            delayedQueue.remove(value);
            delayedQueue.offer(value, delay, timeUnit);
            log.info("(\u6dfb\u52a0\u5ef6\u65f6\u961f\u5217\u6210\u529f) \u961f\u5217\u952e\uff1a{}\uff0c\u961f\u5217\u503c\uff1a{}\uff0c\u5ef6\u8fdf\u65f6\u95f4\uff1a{}", new Object[]{queueCode, value, timeUnit.toSeconds(delay) + "\u79d2"});
        }
        catch (Exception e) {
            log.error("(\u6dfb\u52a0\u5ef6\u65f6\u961f\u5217\u5931\u8d25,\u503c\u4e3a:{}) {}", value, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public <T> boolean addDelayQueue(@NonNull T value, @NonNull Date nowDate, @NonNull Date expiresTime, @NonNull String queueCode) {
        return this.addDelayQueue(value, expiresTime.getTime() - nowDate.getTime(), TimeUnit.MILLISECONDS, queueCode);
    }

    public <T> T getDelayQueuePoll(@NonNull String queueCode) throws InterruptedException {
        if (StringUtils.isBlank((CharSequence)queueCode)) {
            return null;
        }
        RPriorityBlockingDeque blockingDeque = this.redissonClient.getPriorityBlockingDeque(queueCode);
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingDeque);
        Object value = blockingDeque.poll();
        return (T)value;
    }

    public <T> T getDelayQueueTake(@NonNull String queueCode) throws InterruptedException {
        if (StringUtils.isBlank((CharSequence)queueCode)) {
            return null;
        }
        RPriorityBlockingDeque blockingDeque = this.redissonClient.getPriorityBlockingDeque(queueCode);
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingDeque);
        Object value = blockingDeque.take();
        return (T)value;
    }

    public boolean removeDelayedQueue(@NonNull Object o, @NonNull String queueCode) {
        if (StringUtils.isBlank((CharSequence)queueCode)) {
            return false;
        }
        RPriorityBlockingDeque blockingDeque = this.redissonClient.getPriorityBlockingDeque(queueCode);
        RDelayedQueue delayedQueue = this.redissonClient.getDelayedQueue((RQueue)blockingDeque);
        return delayedQueue.remove(o);
    }
}

