/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.common.framework.logback;

import ch.qos.logback.core.pattern.CompositeConverter;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SensitiveConverter
extends CompositeConverter<Object> {
    private static final String phonePattern = "(?:0|86|\\+86)?1[3-9]\\d{9}";
    private static final String idCardPattern = "[1-9]\\d{5}(18|19|20)\\d{2}(0[1-9]|1[0-2])(0[1-9]|1\\d|2[0-9])\\d{3}(\\d|X|x)$|^[1-9]\\d{14}";
    private static final String emailPattern = "[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}";
    private static final Pattern pattern = Pattern.compile("(?:0|86|\\+86)?1[3-9]\\d{9}|[1-9]\\d{5}(18|19|20)\\d{2}(0[1-9]|1[0-2])(0[1-9]|1\\d|2[0-9])\\d{3}(\\d|X|x)$|^[1-9]\\d{14}|[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}");
    private static final List<Character> prefix = Arrays.asList(Character.valueOf(':'), Character.valueOf('\uff1a'));

    protected String transform(Object event, String in) {
        if (in == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(in);
        StringBuffer maskedInput = new StringBuffer();
        while (matcher.find()) {
            String matchedString = matcher.group();
            if (matchedString.matches(phonePattern) && SensitiveConverter.extra(matcher, in)) {
                matcher.appendReplacement(maskedInput, SensitiveConverter.maskPartialData(matchedString, 3, 7));
                continue;
            }
            if (matchedString.matches(idCardPattern) && SensitiveConverter.extra(matcher, in)) {
                matcher.appendReplacement(maskedInput, SensitiveConverter.maskPartialData(matchedString, 6, 14));
                continue;
            }
            if (!matchedString.matches(emailPattern)) continue;
            matcher.appendReplacement(maskedInput, SensitiveConverter.maskEmail(matchedString));
        }
        return matcher.appendTail(maskedInput).toString();
    }

    private static boolean extra(Matcher matcher, String in) {
        int start = matcher.start();
        int end = matcher.end();
        return (start == 0 || !Character.isDigit(in.charAt(start - 1)) && !prefix.contains(Character.valueOf(in.charAt(start - 1)))) && (end == in.length() || !Character.isDigit(in.charAt(end)) && !prefix.contains(Character.valueOf(in.charAt(end))));
    }

    public static String maskPartialData(String data, int start, int end) {
        StringBuilder maskedData = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            if (i >= start && i < end) {
                maskedData.append('*');
                continue;
            }
            maskedData.append(data.charAt(i));
        }
        return maskedData.toString();
    }

    public static String maskEmail(String email) {
        int atIndex = email.indexOf(64);
        if (atIndex > 0) {
            String username = email.substring(0, atIndex);
            String domain = email.substring(atIndex);
            return SensitiveConverter.maskPartialData(username, 2, username.length()) + domain;
        }
        return email;
    }

    public static String maskChineseName(String name) {
        if (name.length() > 1) {
            String firstName = name.substring(0, 1);
            String maskedName = SensitiveConverter.maskPartialData(name.substring(1), 0, name.length() - 1);
            return firstName + maskedName;
        }
        return name;
    }
}

